/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model.transform;

import com.amazonaws.services.personalize.model.Solution;
import com.amazonaws.services.personalize.model.transform.AutoMLResultJsonUnmarshaller;
import com.amazonaws.services.personalize.model.transform.SolutionConfigJsonUnmarshaller;
import com.amazonaws.services.personalize.model.transform.SolutionVersionSummaryJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class SolutionJsonUnmarshaller
implements Unmarshaller<Solution, JsonUnmarshallerContext> {
    private static SolutionJsonUnmarshaller instance;

    public Solution unmarshall(JsonUnmarshallerContext context) throws Exception {
        Solution solution = new Solution();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    solution.setName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("solutionArn", targetDepth)) {
                    context.nextToken();
                    solution.setSolutionArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("performHPO", targetDepth)) {
                    context.nextToken();
                    solution.setPerformHPO((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("performAutoML", targetDepth)) {
                    context.nextToken();
                    solution.setPerformAutoML((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("performAutoTraining", targetDepth)) {
                    context.nextToken();
                    solution.setPerformAutoTraining((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("recipeArn", targetDepth)) {
                    context.nextToken();
                    solution.setRecipeArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("datasetGroupArn", targetDepth)) {
                    context.nextToken();
                    solution.setDatasetGroupArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("eventType", targetDepth)) {
                    context.nextToken();
                    solution.setEventType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("solutionConfig", targetDepth)) {
                    context.nextToken();
                    solution.setSolutionConfig(SolutionConfigJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("autoMLResult", targetDepth)) {
                    context.nextToken();
                    solution.setAutoMLResult(AutoMLResultJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    solution.setStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("creationDateTime", targetDepth)) {
                    context.nextToken();
                    solution.setCreationDateTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("lastUpdatedDateTime", targetDepth)) {
                    context.nextToken();
                    solution.setLastUpdatedDateTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("latestSolutionVersion", targetDepth)) {
                    context.nextToken();
                    solution.setLatestSolutionVersion(SolutionVersionSummaryJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return solution;
    }

    public static SolutionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SolutionJsonUnmarshaller();
        }
        return instance;
    }
}

