/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model.transform;

import com.amazonaws.services.personalize.model.SolutionConfig;
import com.amazonaws.services.personalize.model.transform.AutoMLConfigJsonUnmarshaller;
import com.amazonaws.services.personalize.model.transform.HPOConfigJsonUnmarshaller;
import com.amazonaws.services.personalize.model.transform.OptimizationObjectiveJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class SolutionConfigJsonUnmarshaller
implements Unmarshaller<SolutionConfig, JsonUnmarshallerContext> {
    private static SolutionConfigJsonUnmarshaller instance;

    public SolutionConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        SolutionConfig solutionConfig = new SolutionConfig();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("eventValueThreshold", targetDepth)) {
                    context.nextToken();
                    solutionConfig.setEventValueThreshold((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("hpoConfig", targetDepth)) {
                    context.nextToken();
                    solutionConfig.setHpoConfig(HPOConfigJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("algorithmHyperParameters", targetDepth)) {
                    context.nextToken();
                    solutionConfig.setAlgorithmHyperParameters(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("featureTransformationParameters", targetDepth)) {
                    context.nextToken();
                    solutionConfig.setFeatureTransformationParameters(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("autoMLConfig", targetDepth)) {
                    context.nextToken();
                    solutionConfig.setAutoMLConfig(AutoMLConfigJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("optimizationObjective", targetDepth)) {
                    context.nextToken();
                    solutionConfig.setOptimizationObjective(OptimizationObjectiveJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return solutionConfig;
    }

    public static SolutionConfigJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SolutionConfigJsonUnmarshaller();
        }
        return instance;
    }
}

