/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptographydata.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptographydata.model.MacAttributes;

@SdkInternalApi
public class MacAttributesMarshaller {
    private static final MarshallingInfo<String> ALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Algorithm").build();
    private static final MarshallingInfo<StructuredPojo> EMVMAC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmvMac").build();
    private static final MarshallingInfo<StructuredPojo> DUKPTISO9797ALGORITHM1_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DukptIso9797Algorithm1").build();
    private static final MarshallingInfo<StructuredPojo> DUKPTISO9797ALGORITHM3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DukptIso9797Algorithm3").build();
    private static final MarshallingInfo<StructuredPojo> DUKPTCMAC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DukptCmac").build();
    private static final MacAttributesMarshaller instance = new MacAttributesMarshaller();

    public static MacAttributesMarshaller getInstance() {
        return instance;
    }

    public void marshall(MacAttributes macAttributes, ProtocolMarshaller protocolMarshaller) {
        if (macAttributes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)macAttributes.getAlgorithm(), ALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)macAttributes.getEmvMac(), EMVMAC_BINDING);
            protocolMarshaller.marshall((Object)macAttributes.getDukptIso9797Algorithm1(), DUKPTISO9797ALGORITHM1_BINDING);
            protocolMarshaller.marshall((Object)macAttributes.getDukptIso9797Algorithm3(), DUKPTISO9797ALGORITHM3_BINDING);
            protocolMarshaller.marshall((Object)macAttributes.getDukptCmac(), DUKPTCMAC_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

