/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptographydata.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptographydata.model.DukptDerivationType;
import com.amazonaws.services.paymentcryptographydata.model.DukptEncryptionMode;
import com.amazonaws.services.paymentcryptographydata.model.DukptKeyVariant;
import com.amazonaws.services.paymentcryptographydata.model.transform.DukptEncryptionAttributesMarshaller;
import java.io.Serializable;

public class DukptEncryptionAttributes
implements Serializable,
Cloneable,
StructuredPojo {
    private String keySerialNumber;
    private String mode;
    private String dukptKeyDerivationType;
    private String dukptKeyVariant;
    private String initializationVector;

    public void setKeySerialNumber(String keySerialNumber) {
        this.keySerialNumber = keySerialNumber;
    }

    public String getKeySerialNumber() {
        return this.keySerialNumber;
    }

    public DukptEncryptionAttributes withKeySerialNumber(String keySerialNumber) {
        this.setKeySerialNumber(keySerialNumber);
        return this;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public DukptEncryptionAttributes withMode(String mode) {
        this.setMode(mode);
        return this;
    }

    public DukptEncryptionAttributes withMode(DukptEncryptionMode mode) {
        this.mode = mode.toString();
        return this;
    }

    public void setDukptKeyDerivationType(String dukptKeyDerivationType) {
        this.dukptKeyDerivationType = dukptKeyDerivationType;
    }

    public String getDukptKeyDerivationType() {
        return this.dukptKeyDerivationType;
    }

    public DukptEncryptionAttributes withDukptKeyDerivationType(String dukptKeyDerivationType) {
        this.setDukptKeyDerivationType(dukptKeyDerivationType);
        return this;
    }

    public DukptEncryptionAttributes withDukptKeyDerivationType(DukptDerivationType dukptKeyDerivationType) {
        this.dukptKeyDerivationType = dukptKeyDerivationType.toString();
        return this;
    }

    public void setDukptKeyVariant(String dukptKeyVariant) {
        this.dukptKeyVariant = dukptKeyVariant;
    }

    public String getDukptKeyVariant() {
        return this.dukptKeyVariant;
    }

    public DukptEncryptionAttributes withDukptKeyVariant(String dukptKeyVariant) {
        this.setDukptKeyVariant(dukptKeyVariant);
        return this;
    }

    public DukptEncryptionAttributes withDukptKeyVariant(DukptKeyVariant dukptKeyVariant) {
        this.dukptKeyVariant = dukptKeyVariant.toString();
        return this;
    }

    public void setInitializationVector(String initializationVector) {
        this.initializationVector = initializationVector;
    }

    public String getInitializationVector() {
        return this.initializationVector;
    }

    public DukptEncryptionAttributes withInitializationVector(String initializationVector) {
        this.setInitializationVector(initializationVector);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeySerialNumber() != null) {
            sb.append("KeySerialNumber: ").append(this.getKeySerialNumber()).append(",");
        }
        if (this.getMode() != null) {
            sb.append("Mode: ").append(this.getMode()).append(",");
        }
        if (this.getDukptKeyDerivationType() != null) {
            sb.append("DukptKeyDerivationType: ").append(this.getDukptKeyDerivationType()).append(",");
        }
        if (this.getDukptKeyVariant() != null) {
            sb.append("DukptKeyVariant: ").append(this.getDukptKeyVariant()).append(",");
        }
        if (this.getInitializationVector() != null) {
            sb.append("InitializationVector: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DukptEncryptionAttributes)) {
            return false;
        }
        DukptEncryptionAttributes other = (DukptEncryptionAttributes)obj;
        if (other.getKeySerialNumber() == null ^ this.getKeySerialNumber() == null) {
            return false;
        }
        if (other.getKeySerialNumber() != null && !other.getKeySerialNumber().equals(this.getKeySerialNumber())) {
            return false;
        }
        if (other.getMode() == null ^ this.getMode() == null) {
            return false;
        }
        if (other.getMode() != null && !other.getMode().equals(this.getMode())) {
            return false;
        }
        if (other.getDukptKeyDerivationType() == null ^ this.getDukptKeyDerivationType() == null) {
            return false;
        }
        if (other.getDukptKeyDerivationType() != null && !other.getDukptKeyDerivationType().equals(this.getDukptKeyDerivationType())) {
            return false;
        }
        if (other.getDukptKeyVariant() == null ^ this.getDukptKeyVariant() == null) {
            return false;
        }
        if (other.getDukptKeyVariant() != null && !other.getDukptKeyVariant().equals(this.getDukptKeyVariant())) {
            return false;
        }
        if (other.getInitializationVector() == null ^ this.getInitializationVector() == null) {
            return false;
        }
        return other.getInitializationVector() == null || other.getInitializationVector().equals(this.getInitializationVector());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeySerialNumber() == null ? 0 : this.getKeySerialNumber().hashCode());
        hashCode = 31 * hashCode + (this.getMode() == null ? 0 : this.getMode().hashCode());
        hashCode = 31 * hashCode + (this.getDukptKeyDerivationType() == null ? 0 : this.getDukptKeyDerivationType().hashCode());
        hashCode = 31 * hashCode + (this.getDukptKeyVariant() == null ? 0 : this.getDukptKeyVariant().hashCode());
        hashCode = 31 * hashCode + (this.getInitializationVector() == null ? 0 : this.getInitializationVector().hashCode());
        return hashCode;
    }

    public DukptEncryptionAttributes clone() {
        try {
            return (DukptEncryptionAttributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DukptEncryptionAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

