/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.panorama;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.panorama.AWSPanoramaAsync;
import com.amazonaws.services.panorama.AWSPanoramaAsyncClientBuilder;
import com.amazonaws.services.panorama.AWSPanoramaClient;
import com.amazonaws.services.panorama.model.CreateApplicationInstanceRequest;
import com.amazonaws.services.panorama.model.CreateApplicationInstanceResult;
import com.amazonaws.services.panorama.model.CreateJobForDevicesRequest;
import com.amazonaws.services.panorama.model.CreateJobForDevicesResult;
import com.amazonaws.services.panorama.model.CreateNodeFromTemplateJobRequest;
import com.amazonaws.services.panorama.model.CreateNodeFromTemplateJobResult;
import com.amazonaws.services.panorama.model.CreatePackageImportJobRequest;
import com.amazonaws.services.panorama.model.CreatePackageImportJobResult;
import com.amazonaws.services.panorama.model.CreatePackageRequest;
import com.amazonaws.services.panorama.model.CreatePackageResult;
import com.amazonaws.services.panorama.model.DeleteDeviceRequest;
import com.amazonaws.services.panorama.model.DeleteDeviceResult;
import com.amazonaws.services.panorama.model.DeletePackageRequest;
import com.amazonaws.services.panorama.model.DeletePackageResult;
import com.amazonaws.services.panorama.model.DeregisterPackageVersionRequest;
import com.amazonaws.services.panorama.model.DeregisterPackageVersionResult;
import com.amazonaws.services.panorama.model.DescribeApplicationInstanceDetailsRequest;
import com.amazonaws.services.panorama.model.DescribeApplicationInstanceDetailsResult;
import com.amazonaws.services.panorama.model.DescribeApplicationInstanceRequest;
import com.amazonaws.services.panorama.model.DescribeApplicationInstanceResult;
import com.amazonaws.services.panorama.model.DescribeDeviceJobRequest;
import com.amazonaws.services.panorama.model.DescribeDeviceJobResult;
import com.amazonaws.services.panorama.model.DescribeDeviceRequest;
import com.amazonaws.services.panorama.model.DescribeDeviceResult;
import com.amazonaws.services.panorama.model.DescribeNodeFromTemplateJobRequest;
import com.amazonaws.services.panorama.model.DescribeNodeFromTemplateJobResult;
import com.amazonaws.services.panorama.model.DescribeNodeRequest;
import com.amazonaws.services.panorama.model.DescribeNodeResult;
import com.amazonaws.services.panorama.model.DescribePackageImportJobRequest;
import com.amazonaws.services.panorama.model.DescribePackageImportJobResult;
import com.amazonaws.services.panorama.model.DescribePackageRequest;
import com.amazonaws.services.panorama.model.DescribePackageResult;
import com.amazonaws.services.panorama.model.DescribePackageVersionRequest;
import com.amazonaws.services.panorama.model.DescribePackageVersionResult;
import com.amazonaws.services.panorama.model.ListApplicationInstanceDependenciesRequest;
import com.amazonaws.services.panorama.model.ListApplicationInstanceDependenciesResult;
import com.amazonaws.services.panorama.model.ListApplicationInstanceNodeInstancesRequest;
import com.amazonaws.services.panorama.model.ListApplicationInstanceNodeInstancesResult;
import com.amazonaws.services.panorama.model.ListApplicationInstancesRequest;
import com.amazonaws.services.panorama.model.ListApplicationInstancesResult;
import com.amazonaws.services.panorama.model.ListDevicesJobsRequest;
import com.amazonaws.services.panorama.model.ListDevicesJobsResult;
import com.amazonaws.services.panorama.model.ListDevicesRequest;
import com.amazonaws.services.panorama.model.ListDevicesResult;
import com.amazonaws.services.panorama.model.ListNodeFromTemplateJobsRequest;
import com.amazonaws.services.panorama.model.ListNodeFromTemplateJobsResult;
import com.amazonaws.services.panorama.model.ListNodesRequest;
import com.amazonaws.services.panorama.model.ListNodesResult;
import com.amazonaws.services.panorama.model.ListPackageImportJobsRequest;
import com.amazonaws.services.panorama.model.ListPackageImportJobsResult;
import com.amazonaws.services.panorama.model.ListPackagesRequest;
import com.amazonaws.services.panorama.model.ListPackagesResult;
import com.amazonaws.services.panorama.model.ListTagsForResourceRequest;
import com.amazonaws.services.panorama.model.ListTagsForResourceResult;
import com.amazonaws.services.panorama.model.ProvisionDeviceRequest;
import com.amazonaws.services.panorama.model.ProvisionDeviceResult;
import com.amazonaws.services.panorama.model.RegisterPackageVersionRequest;
import com.amazonaws.services.panorama.model.RegisterPackageVersionResult;
import com.amazonaws.services.panorama.model.RemoveApplicationInstanceRequest;
import com.amazonaws.services.panorama.model.RemoveApplicationInstanceResult;
import com.amazonaws.services.panorama.model.SignalApplicationInstanceNodeInstancesRequest;
import com.amazonaws.services.panorama.model.SignalApplicationInstanceNodeInstancesResult;
import com.amazonaws.services.panorama.model.TagResourceRequest;
import com.amazonaws.services.panorama.model.TagResourceResult;
import com.amazonaws.services.panorama.model.UntagResourceRequest;
import com.amazonaws.services.panorama.model.UntagResourceResult;
import com.amazonaws.services.panorama.model.UpdateDeviceMetadataRequest;
import com.amazonaws.services.panorama.model.UpdateDeviceMetadataResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSPanoramaAsyncClient
extends AWSPanoramaClient
implements AWSPanoramaAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSPanoramaAsyncClientBuilder asyncBuilder() {
        return AWSPanoramaAsyncClientBuilder.standard();
    }

    AWSPanoramaAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSPanoramaAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateApplicationInstanceResult> createApplicationInstanceAsync(CreateApplicationInstanceRequest request) {
        return this.createApplicationInstanceAsync(request, null);
    }

    @Override
    public Future<CreateApplicationInstanceResult> createApplicationInstanceAsync(CreateApplicationInstanceRequest request, final AsyncHandler<CreateApplicationInstanceRequest, CreateApplicationInstanceResult> asyncHandler) {
        final CreateApplicationInstanceRequest finalRequest = (CreateApplicationInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateApplicationInstanceResult>(){

            @Override
            public CreateApplicationInstanceResult call() throws Exception {
                CreateApplicationInstanceResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeCreateApplicationInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateJobForDevicesResult> createJobForDevicesAsync(CreateJobForDevicesRequest request) {
        return this.createJobForDevicesAsync(request, null);
    }

    @Override
    public Future<CreateJobForDevicesResult> createJobForDevicesAsync(CreateJobForDevicesRequest request, final AsyncHandler<CreateJobForDevicesRequest, CreateJobForDevicesResult> asyncHandler) {
        final CreateJobForDevicesRequest finalRequest = (CreateJobForDevicesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateJobForDevicesResult>(){

            @Override
            public CreateJobForDevicesResult call() throws Exception {
                CreateJobForDevicesResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeCreateJobForDevices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateNodeFromTemplateJobResult> createNodeFromTemplateJobAsync(CreateNodeFromTemplateJobRequest request) {
        return this.createNodeFromTemplateJobAsync(request, null);
    }

    @Override
    public Future<CreateNodeFromTemplateJobResult> createNodeFromTemplateJobAsync(CreateNodeFromTemplateJobRequest request, final AsyncHandler<CreateNodeFromTemplateJobRequest, CreateNodeFromTemplateJobResult> asyncHandler) {
        final CreateNodeFromTemplateJobRequest finalRequest = (CreateNodeFromTemplateJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateNodeFromTemplateJobResult>(){

            @Override
            public CreateNodeFromTemplateJobResult call() throws Exception {
                CreateNodeFromTemplateJobResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeCreateNodeFromTemplateJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePackageResult> createPackageAsync(CreatePackageRequest request) {
        return this.createPackageAsync(request, null);
    }

    @Override
    public Future<CreatePackageResult> createPackageAsync(CreatePackageRequest request, final AsyncHandler<CreatePackageRequest, CreatePackageResult> asyncHandler) {
        final CreatePackageRequest finalRequest = (CreatePackageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePackageResult>(){

            @Override
            public CreatePackageResult call() throws Exception {
                CreatePackageResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeCreatePackage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePackageImportJobResult> createPackageImportJobAsync(CreatePackageImportJobRequest request) {
        return this.createPackageImportJobAsync(request, null);
    }

    @Override
    public Future<CreatePackageImportJobResult> createPackageImportJobAsync(CreatePackageImportJobRequest request, final AsyncHandler<CreatePackageImportJobRequest, CreatePackageImportJobResult> asyncHandler) {
        final CreatePackageImportJobRequest finalRequest = (CreatePackageImportJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePackageImportJobResult>(){

            @Override
            public CreatePackageImportJobResult call() throws Exception {
                CreatePackageImportJobResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeCreatePackageImportJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDeviceResult> deleteDeviceAsync(DeleteDeviceRequest request) {
        return this.deleteDeviceAsync(request, null);
    }

    @Override
    public Future<DeleteDeviceResult> deleteDeviceAsync(DeleteDeviceRequest request, final AsyncHandler<DeleteDeviceRequest, DeleteDeviceResult> asyncHandler) {
        final DeleteDeviceRequest finalRequest = (DeleteDeviceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDeviceResult>(){

            @Override
            public DeleteDeviceResult call() throws Exception {
                DeleteDeviceResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeDeleteDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePackageResult> deletePackageAsync(DeletePackageRequest request) {
        return this.deletePackageAsync(request, null);
    }

    @Override
    public Future<DeletePackageResult> deletePackageAsync(DeletePackageRequest request, final AsyncHandler<DeletePackageRequest, DeletePackageResult> asyncHandler) {
        final DeletePackageRequest finalRequest = (DeletePackageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePackageResult>(){

            @Override
            public DeletePackageResult call() throws Exception {
                DeletePackageResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeDeletePackage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterPackageVersionResult> deregisterPackageVersionAsync(DeregisterPackageVersionRequest request) {
        return this.deregisterPackageVersionAsync(request, null);
    }

    @Override
    public Future<DeregisterPackageVersionResult> deregisterPackageVersionAsync(DeregisterPackageVersionRequest request, final AsyncHandler<DeregisterPackageVersionRequest, DeregisterPackageVersionResult> asyncHandler) {
        final DeregisterPackageVersionRequest finalRequest = (DeregisterPackageVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeregisterPackageVersionResult>(){

            @Override
            public DeregisterPackageVersionResult call() throws Exception {
                DeregisterPackageVersionResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeDeregisterPackageVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeApplicationInstanceResult> describeApplicationInstanceAsync(DescribeApplicationInstanceRequest request) {
        return this.describeApplicationInstanceAsync(request, null);
    }

    @Override
    public Future<DescribeApplicationInstanceResult> describeApplicationInstanceAsync(DescribeApplicationInstanceRequest request, final AsyncHandler<DescribeApplicationInstanceRequest, DescribeApplicationInstanceResult> asyncHandler) {
        final DescribeApplicationInstanceRequest finalRequest = (DescribeApplicationInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeApplicationInstanceResult>(){

            @Override
            public DescribeApplicationInstanceResult call() throws Exception {
                DescribeApplicationInstanceResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeDescribeApplicationInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeApplicationInstanceDetailsResult> describeApplicationInstanceDetailsAsync(DescribeApplicationInstanceDetailsRequest request) {
        return this.describeApplicationInstanceDetailsAsync(request, null);
    }

    @Override
    public Future<DescribeApplicationInstanceDetailsResult> describeApplicationInstanceDetailsAsync(DescribeApplicationInstanceDetailsRequest request, final AsyncHandler<DescribeApplicationInstanceDetailsRequest, DescribeApplicationInstanceDetailsResult> asyncHandler) {
        final DescribeApplicationInstanceDetailsRequest finalRequest = (DescribeApplicationInstanceDetailsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeApplicationInstanceDetailsResult>(){

            @Override
            public DescribeApplicationInstanceDetailsResult call() throws Exception {
                DescribeApplicationInstanceDetailsResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeDescribeApplicationInstanceDetails(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDeviceResult> describeDeviceAsync(DescribeDeviceRequest request) {
        return this.describeDeviceAsync(request, null);
    }

    @Override
    public Future<DescribeDeviceResult> describeDeviceAsync(DescribeDeviceRequest request, final AsyncHandler<DescribeDeviceRequest, DescribeDeviceResult> asyncHandler) {
        final DescribeDeviceRequest finalRequest = (DescribeDeviceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDeviceResult>(){

            @Override
            public DescribeDeviceResult call() throws Exception {
                DescribeDeviceResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeDescribeDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDeviceJobResult> describeDeviceJobAsync(DescribeDeviceJobRequest request) {
        return this.describeDeviceJobAsync(request, null);
    }

    @Override
    public Future<DescribeDeviceJobResult> describeDeviceJobAsync(DescribeDeviceJobRequest request, final AsyncHandler<DescribeDeviceJobRequest, DescribeDeviceJobResult> asyncHandler) {
        final DescribeDeviceJobRequest finalRequest = (DescribeDeviceJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDeviceJobResult>(){

            @Override
            public DescribeDeviceJobResult call() throws Exception {
                DescribeDeviceJobResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeDescribeDeviceJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeNodeResult> describeNodeAsync(DescribeNodeRequest request) {
        return this.describeNodeAsync(request, null);
    }

    @Override
    public Future<DescribeNodeResult> describeNodeAsync(DescribeNodeRequest request, final AsyncHandler<DescribeNodeRequest, DescribeNodeResult> asyncHandler) {
        final DescribeNodeRequest finalRequest = (DescribeNodeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeNodeResult>(){

            @Override
            public DescribeNodeResult call() throws Exception {
                DescribeNodeResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeDescribeNode(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeNodeFromTemplateJobResult> describeNodeFromTemplateJobAsync(DescribeNodeFromTemplateJobRequest request) {
        return this.describeNodeFromTemplateJobAsync(request, null);
    }

    @Override
    public Future<DescribeNodeFromTemplateJobResult> describeNodeFromTemplateJobAsync(DescribeNodeFromTemplateJobRequest request, final AsyncHandler<DescribeNodeFromTemplateJobRequest, DescribeNodeFromTemplateJobResult> asyncHandler) {
        final DescribeNodeFromTemplateJobRequest finalRequest = (DescribeNodeFromTemplateJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeNodeFromTemplateJobResult>(){

            @Override
            public DescribeNodeFromTemplateJobResult call() throws Exception {
                DescribeNodeFromTemplateJobResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeDescribeNodeFromTemplateJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePackageResult> describePackageAsync(DescribePackageRequest request) {
        return this.describePackageAsync(request, null);
    }

    @Override
    public Future<DescribePackageResult> describePackageAsync(DescribePackageRequest request, final AsyncHandler<DescribePackageRequest, DescribePackageResult> asyncHandler) {
        final DescribePackageRequest finalRequest = (DescribePackageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePackageResult>(){

            @Override
            public DescribePackageResult call() throws Exception {
                DescribePackageResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeDescribePackage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePackageImportJobResult> describePackageImportJobAsync(DescribePackageImportJobRequest request) {
        return this.describePackageImportJobAsync(request, null);
    }

    @Override
    public Future<DescribePackageImportJobResult> describePackageImportJobAsync(DescribePackageImportJobRequest request, final AsyncHandler<DescribePackageImportJobRequest, DescribePackageImportJobResult> asyncHandler) {
        final DescribePackageImportJobRequest finalRequest = (DescribePackageImportJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePackageImportJobResult>(){

            @Override
            public DescribePackageImportJobResult call() throws Exception {
                DescribePackageImportJobResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeDescribePackageImportJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePackageVersionResult> describePackageVersionAsync(DescribePackageVersionRequest request) {
        return this.describePackageVersionAsync(request, null);
    }

    @Override
    public Future<DescribePackageVersionResult> describePackageVersionAsync(DescribePackageVersionRequest request, final AsyncHandler<DescribePackageVersionRequest, DescribePackageVersionResult> asyncHandler) {
        final DescribePackageVersionRequest finalRequest = (DescribePackageVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePackageVersionResult>(){

            @Override
            public DescribePackageVersionResult call() throws Exception {
                DescribePackageVersionResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeDescribePackageVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApplicationInstanceDependenciesResult> listApplicationInstanceDependenciesAsync(ListApplicationInstanceDependenciesRequest request) {
        return this.listApplicationInstanceDependenciesAsync(request, null);
    }

    @Override
    public Future<ListApplicationInstanceDependenciesResult> listApplicationInstanceDependenciesAsync(ListApplicationInstanceDependenciesRequest request, final AsyncHandler<ListApplicationInstanceDependenciesRequest, ListApplicationInstanceDependenciesResult> asyncHandler) {
        final ListApplicationInstanceDependenciesRequest finalRequest = (ListApplicationInstanceDependenciesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListApplicationInstanceDependenciesResult>(){

            @Override
            public ListApplicationInstanceDependenciesResult call() throws Exception {
                ListApplicationInstanceDependenciesResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeListApplicationInstanceDependencies(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApplicationInstanceNodeInstancesResult> listApplicationInstanceNodeInstancesAsync(ListApplicationInstanceNodeInstancesRequest request) {
        return this.listApplicationInstanceNodeInstancesAsync(request, null);
    }

    @Override
    public Future<ListApplicationInstanceNodeInstancesResult> listApplicationInstanceNodeInstancesAsync(ListApplicationInstanceNodeInstancesRequest request, final AsyncHandler<ListApplicationInstanceNodeInstancesRequest, ListApplicationInstanceNodeInstancesResult> asyncHandler) {
        final ListApplicationInstanceNodeInstancesRequest finalRequest = (ListApplicationInstanceNodeInstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListApplicationInstanceNodeInstancesResult>(){

            @Override
            public ListApplicationInstanceNodeInstancesResult call() throws Exception {
                ListApplicationInstanceNodeInstancesResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeListApplicationInstanceNodeInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApplicationInstancesResult> listApplicationInstancesAsync(ListApplicationInstancesRequest request) {
        return this.listApplicationInstancesAsync(request, null);
    }

    @Override
    public Future<ListApplicationInstancesResult> listApplicationInstancesAsync(ListApplicationInstancesRequest request, final AsyncHandler<ListApplicationInstancesRequest, ListApplicationInstancesResult> asyncHandler) {
        final ListApplicationInstancesRequest finalRequest = (ListApplicationInstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListApplicationInstancesResult>(){

            @Override
            public ListApplicationInstancesResult call() throws Exception {
                ListApplicationInstancesResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeListApplicationInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDevicesResult> listDevicesAsync(ListDevicesRequest request) {
        return this.listDevicesAsync(request, null);
    }

    @Override
    public Future<ListDevicesResult> listDevicesAsync(ListDevicesRequest request, final AsyncHandler<ListDevicesRequest, ListDevicesResult> asyncHandler) {
        final ListDevicesRequest finalRequest = (ListDevicesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDevicesResult>(){

            @Override
            public ListDevicesResult call() throws Exception {
                ListDevicesResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeListDevices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDevicesJobsResult> listDevicesJobsAsync(ListDevicesJobsRequest request) {
        return this.listDevicesJobsAsync(request, null);
    }

    @Override
    public Future<ListDevicesJobsResult> listDevicesJobsAsync(ListDevicesJobsRequest request, final AsyncHandler<ListDevicesJobsRequest, ListDevicesJobsResult> asyncHandler) {
        final ListDevicesJobsRequest finalRequest = (ListDevicesJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDevicesJobsResult>(){

            @Override
            public ListDevicesJobsResult call() throws Exception {
                ListDevicesJobsResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeListDevicesJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNodeFromTemplateJobsResult> listNodeFromTemplateJobsAsync(ListNodeFromTemplateJobsRequest request) {
        return this.listNodeFromTemplateJobsAsync(request, null);
    }

    @Override
    public Future<ListNodeFromTemplateJobsResult> listNodeFromTemplateJobsAsync(ListNodeFromTemplateJobsRequest request, final AsyncHandler<ListNodeFromTemplateJobsRequest, ListNodeFromTemplateJobsResult> asyncHandler) {
        final ListNodeFromTemplateJobsRequest finalRequest = (ListNodeFromTemplateJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNodeFromTemplateJobsResult>(){

            @Override
            public ListNodeFromTemplateJobsResult call() throws Exception {
                ListNodeFromTemplateJobsResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeListNodeFromTemplateJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNodesResult> listNodesAsync(ListNodesRequest request) {
        return this.listNodesAsync(request, null);
    }

    @Override
    public Future<ListNodesResult> listNodesAsync(ListNodesRequest request, final AsyncHandler<ListNodesRequest, ListNodesResult> asyncHandler) {
        final ListNodesRequest finalRequest = (ListNodesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNodesResult>(){

            @Override
            public ListNodesResult call() throws Exception {
                ListNodesResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeListNodes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPackageImportJobsResult> listPackageImportJobsAsync(ListPackageImportJobsRequest request) {
        return this.listPackageImportJobsAsync(request, null);
    }

    @Override
    public Future<ListPackageImportJobsResult> listPackageImportJobsAsync(ListPackageImportJobsRequest request, final AsyncHandler<ListPackageImportJobsRequest, ListPackageImportJobsResult> asyncHandler) {
        final ListPackageImportJobsRequest finalRequest = (ListPackageImportJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPackageImportJobsResult>(){

            @Override
            public ListPackageImportJobsResult call() throws Exception {
                ListPackageImportJobsResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeListPackageImportJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPackagesResult> listPackagesAsync(ListPackagesRequest request) {
        return this.listPackagesAsync(request, null);
    }

    @Override
    public Future<ListPackagesResult> listPackagesAsync(ListPackagesRequest request, final AsyncHandler<ListPackagesRequest, ListPackagesResult> asyncHandler) {
        final ListPackagesRequest finalRequest = (ListPackagesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPackagesResult>(){

            @Override
            public ListPackagesResult call() throws Exception {
                ListPackagesResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeListPackages(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ProvisionDeviceResult> provisionDeviceAsync(ProvisionDeviceRequest request) {
        return this.provisionDeviceAsync(request, null);
    }

    @Override
    public Future<ProvisionDeviceResult> provisionDeviceAsync(ProvisionDeviceRequest request, final AsyncHandler<ProvisionDeviceRequest, ProvisionDeviceResult> asyncHandler) {
        final ProvisionDeviceRequest finalRequest = (ProvisionDeviceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ProvisionDeviceResult>(){

            @Override
            public ProvisionDeviceResult call() throws Exception {
                ProvisionDeviceResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeProvisionDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterPackageVersionResult> registerPackageVersionAsync(RegisterPackageVersionRequest request) {
        return this.registerPackageVersionAsync(request, null);
    }

    @Override
    public Future<RegisterPackageVersionResult> registerPackageVersionAsync(RegisterPackageVersionRequest request, final AsyncHandler<RegisterPackageVersionRequest, RegisterPackageVersionResult> asyncHandler) {
        final RegisterPackageVersionRequest finalRequest = (RegisterPackageVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterPackageVersionResult>(){

            @Override
            public RegisterPackageVersionResult call() throws Exception {
                RegisterPackageVersionResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeRegisterPackageVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveApplicationInstanceResult> removeApplicationInstanceAsync(RemoveApplicationInstanceRequest request) {
        return this.removeApplicationInstanceAsync(request, null);
    }

    @Override
    public Future<RemoveApplicationInstanceResult> removeApplicationInstanceAsync(RemoveApplicationInstanceRequest request, final AsyncHandler<RemoveApplicationInstanceRequest, RemoveApplicationInstanceResult> asyncHandler) {
        final RemoveApplicationInstanceRequest finalRequest = (RemoveApplicationInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveApplicationInstanceResult>(){

            @Override
            public RemoveApplicationInstanceResult call() throws Exception {
                RemoveApplicationInstanceResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeRemoveApplicationInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SignalApplicationInstanceNodeInstancesResult> signalApplicationInstanceNodeInstancesAsync(SignalApplicationInstanceNodeInstancesRequest request) {
        return this.signalApplicationInstanceNodeInstancesAsync(request, null);
    }

    @Override
    public Future<SignalApplicationInstanceNodeInstancesResult> signalApplicationInstanceNodeInstancesAsync(SignalApplicationInstanceNodeInstancesRequest request, final AsyncHandler<SignalApplicationInstanceNodeInstancesRequest, SignalApplicationInstanceNodeInstancesResult> asyncHandler) {
        final SignalApplicationInstanceNodeInstancesRequest finalRequest = (SignalApplicationInstanceNodeInstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SignalApplicationInstanceNodeInstancesResult>(){

            @Override
            public SignalApplicationInstanceNodeInstancesResult call() throws Exception {
                SignalApplicationInstanceNodeInstancesResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeSignalApplicationInstanceNodeInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDeviceMetadataResult> updateDeviceMetadataAsync(UpdateDeviceMetadataRequest request) {
        return this.updateDeviceMetadataAsync(request, null);
    }

    @Override
    public Future<UpdateDeviceMetadataResult> updateDeviceMetadataAsync(UpdateDeviceMetadataRequest request, final AsyncHandler<UpdateDeviceMetadataRequest, UpdateDeviceMetadataResult> asyncHandler) {
        final UpdateDeviceMetadataRequest finalRequest = (UpdateDeviceMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDeviceMetadataResult>(){

            @Override
            public UpdateDeviceMetadataResult call() throws Exception {
                UpdateDeviceMetadataResult result = null;
                try {
                    result = AWSPanoramaAsyncClient.this.executeUpdateDeviceMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

