/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.outposts.model.LineItemRequest;
import com.amazonaws.services.outposts.model.PaymentOption;
import com.amazonaws.services.outposts.model.PaymentTerm;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateOrderRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String outpostIdentifier;
    private List<LineItemRequest> lineItems;
    private String paymentOption;
    private String paymentTerm;

    public void setOutpostIdentifier(String outpostIdentifier) {
        this.outpostIdentifier = outpostIdentifier;
    }

    public String getOutpostIdentifier() {
        return this.outpostIdentifier;
    }

    public CreateOrderRequest withOutpostIdentifier(String outpostIdentifier) {
        this.setOutpostIdentifier(outpostIdentifier);
        return this;
    }

    public List<LineItemRequest> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(Collection<LineItemRequest> lineItems) {
        if (lineItems == null) {
            this.lineItems = null;
            return;
        }
        this.lineItems = new ArrayList<LineItemRequest>(lineItems);
    }

    public CreateOrderRequest withLineItems(LineItemRequest ... lineItems) {
        if (this.lineItems == null) {
            this.setLineItems(new ArrayList<LineItemRequest>(lineItems.length));
        }
        for (LineItemRequest ele : lineItems) {
            this.lineItems.add(ele);
        }
        return this;
    }

    public CreateOrderRequest withLineItems(Collection<LineItemRequest> lineItems) {
        this.setLineItems(lineItems);
        return this;
    }

    public void setPaymentOption(String paymentOption) {
        this.paymentOption = paymentOption;
    }

    public String getPaymentOption() {
        return this.paymentOption;
    }

    public CreateOrderRequest withPaymentOption(String paymentOption) {
        this.setPaymentOption(paymentOption);
        return this;
    }

    public CreateOrderRequest withPaymentOption(PaymentOption paymentOption) {
        this.paymentOption = paymentOption.toString();
        return this;
    }

    public void setPaymentTerm(String paymentTerm) {
        this.paymentTerm = paymentTerm;
    }

    public String getPaymentTerm() {
        return this.paymentTerm;
    }

    public CreateOrderRequest withPaymentTerm(String paymentTerm) {
        this.setPaymentTerm(paymentTerm);
        return this;
    }

    public CreateOrderRequest withPaymentTerm(PaymentTerm paymentTerm) {
        this.paymentTerm = paymentTerm.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOutpostIdentifier() != null) {
            sb.append("OutpostIdentifier: ").append(this.getOutpostIdentifier()).append(",");
        }
        if (this.getLineItems() != null) {
            sb.append("LineItems: ").append(this.getLineItems()).append(",");
        }
        if (this.getPaymentOption() != null) {
            sb.append("PaymentOption: ").append(this.getPaymentOption()).append(",");
        }
        if (this.getPaymentTerm() != null) {
            sb.append("PaymentTerm: ").append(this.getPaymentTerm());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOrderRequest)) {
            return false;
        }
        CreateOrderRequest other = (CreateOrderRequest)obj;
        if (other.getOutpostIdentifier() == null ^ this.getOutpostIdentifier() == null) {
            return false;
        }
        if (other.getOutpostIdentifier() != null && !other.getOutpostIdentifier().equals(this.getOutpostIdentifier())) {
            return false;
        }
        if (other.getLineItems() == null ^ this.getLineItems() == null) {
            return false;
        }
        if (other.getLineItems() != null && !other.getLineItems().equals(this.getLineItems())) {
            return false;
        }
        if (other.getPaymentOption() == null ^ this.getPaymentOption() == null) {
            return false;
        }
        if (other.getPaymentOption() != null && !other.getPaymentOption().equals(this.getPaymentOption())) {
            return false;
        }
        if (other.getPaymentTerm() == null ^ this.getPaymentTerm() == null) {
            return false;
        }
        return other.getPaymentTerm() == null || other.getPaymentTerm().equals(this.getPaymentTerm());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOutpostIdentifier() == null ? 0 : this.getOutpostIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getLineItems() == null ? 0 : this.getLineItems().hashCode());
        hashCode = 31 * hashCode + (this.getPaymentOption() == null ? 0 : this.getPaymentOption().hashCode());
        hashCode = 31 * hashCode + (this.getPaymentTerm() == null ? 0 : this.getPaymentTerm().hashCode());
        return hashCode;
    }

    public CreateOrderRequest clone() {
        return (CreateOrderRequest)super.clone();
    }
}

