/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.outposts.model.Site;
import java.util.Map;

@SdkInternalApi
public class SiteMarshaller {
    private static final MarshallingInfo<String> SITEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SiteId").build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final MarshallingInfo<String> SITEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SiteArn").build();
    private static final MarshallingInfo<String> NOTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Notes").build();
    private static final MarshallingInfo<String> OPERATINGADDRESSCOUNTRYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OperatingAddressCountryCode").build();
    private static final MarshallingInfo<String> OPERATINGADDRESSSTATEORREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OperatingAddressStateOrRegion").build();
    private static final MarshallingInfo<String> OPERATINGADDRESSCITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OperatingAddressCity").build();
    private static final MarshallingInfo<StructuredPojo> RACKPHYSICALPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RackPhysicalProperties").build();
    private static final SiteMarshaller instance = new SiteMarshaller();

    public static SiteMarshaller getInstance() {
        return instance;
    }

    public void marshall(Site site, ProtocolMarshaller protocolMarshaller) {
        if (site == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)site.getSiteId(), SITEID_BINDING);
            protocolMarshaller.marshall((Object)site.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)site.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)site.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(site.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)site.getSiteArn(), SITEARN_BINDING);
            protocolMarshaller.marshall((Object)site.getNotes(), NOTES_BINDING);
            protocolMarshaller.marshall((Object)site.getOperatingAddressCountryCode(), OPERATINGADDRESSCOUNTRYCODE_BINDING);
            protocolMarshaller.marshall((Object)site.getOperatingAddressStateOrRegion(), OPERATINGADDRESSSTATEORREGION_BINDING);
            protocolMarshaller.marshall((Object)site.getOperatingAddressCity(), OPERATINGADDRESSCITY_BINDING);
            protocolMarshaller.marshall((Object)site.getRackPhysicalProperties(), RACKPHYSICALPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

