/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.outposts.model.OrderStatus;
import com.amazonaws.services.outposts.model.OrderType;
import com.amazonaws.services.outposts.model.transform.OrderSummaryMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class OrderSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String outpostId;
    private String orderId;
    private String orderType;
    private String status;
    private Map<String, Integer> lineItemCountsByStatus;
    private Date orderSubmissionDate;
    private Date orderFulfilledDate;

    public void setOutpostId(String outpostId) {
        this.outpostId = outpostId;
    }

    public String getOutpostId() {
        return this.outpostId;
    }

    public OrderSummary withOutpostId(String outpostId) {
        this.setOutpostId(outpostId);
        return this;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public OrderSummary withOrderId(String orderId) {
        this.setOrderId(orderId);
        return this;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public OrderSummary withOrderType(String orderType) {
        this.setOrderType(orderType);
        return this;
    }

    public OrderSummary withOrderType(OrderType orderType) {
        this.orderType = orderType.toString();
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public OrderSummary withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public OrderSummary withStatus(OrderStatus status) {
        this.status = status.toString();
        return this;
    }

    public Map<String, Integer> getLineItemCountsByStatus() {
        return this.lineItemCountsByStatus;
    }

    public void setLineItemCountsByStatus(Map<String, Integer> lineItemCountsByStatus) {
        this.lineItemCountsByStatus = lineItemCountsByStatus;
    }

    public OrderSummary withLineItemCountsByStatus(Map<String, Integer> lineItemCountsByStatus) {
        this.setLineItemCountsByStatus(lineItemCountsByStatus);
        return this;
    }

    public OrderSummary addLineItemCountsByStatusEntry(String key, Integer value) {
        if (null == this.lineItemCountsByStatus) {
            this.lineItemCountsByStatus = new HashMap<String, Integer>();
        }
        if (this.lineItemCountsByStatus.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.lineItemCountsByStatus.put(key, value);
        return this;
    }

    public OrderSummary clearLineItemCountsByStatusEntries() {
        this.lineItemCountsByStatus = null;
        return this;
    }

    public void setOrderSubmissionDate(Date orderSubmissionDate) {
        this.orderSubmissionDate = orderSubmissionDate;
    }

    public Date getOrderSubmissionDate() {
        return this.orderSubmissionDate;
    }

    public OrderSummary withOrderSubmissionDate(Date orderSubmissionDate) {
        this.setOrderSubmissionDate(orderSubmissionDate);
        return this;
    }

    public void setOrderFulfilledDate(Date orderFulfilledDate) {
        this.orderFulfilledDate = orderFulfilledDate;
    }

    public Date getOrderFulfilledDate() {
        return this.orderFulfilledDate;
    }

    public OrderSummary withOrderFulfilledDate(Date orderFulfilledDate) {
        this.setOrderFulfilledDate(orderFulfilledDate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOutpostId() != null) {
            sb.append("OutpostId: ").append(this.getOutpostId()).append(",");
        }
        if (this.getOrderId() != null) {
            sb.append("OrderId: ").append(this.getOrderId()).append(",");
        }
        if (this.getOrderType() != null) {
            sb.append("OrderType: ").append(this.getOrderType()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getLineItemCountsByStatus() != null) {
            sb.append("LineItemCountsByStatus: ").append(this.getLineItemCountsByStatus()).append(",");
        }
        if (this.getOrderSubmissionDate() != null) {
            sb.append("OrderSubmissionDate: ").append(this.getOrderSubmissionDate()).append(",");
        }
        if (this.getOrderFulfilledDate() != null) {
            sb.append("OrderFulfilledDate: ").append(this.getOrderFulfilledDate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderSummary)) {
            return false;
        }
        OrderSummary other = (OrderSummary)obj;
        if (other.getOutpostId() == null ^ this.getOutpostId() == null) {
            return false;
        }
        if (other.getOutpostId() != null && !other.getOutpostId().equals(this.getOutpostId())) {
            return false;
        }
        if (other.getOrderId() == null ^ this.getOrderId() == null) {
            return false;
        }
        if (other.getOrderId() != null && !other.getOrderId().equals(this.getOrderId())) {
            return false;
        }
        if (other.getOrderType() == null ^ this.getOrderType() == null) {
            return false;
        }
        if (other.getOrderType() != null && !other.getOrderType().equals(this.getOrderType())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getLineItemCountsByStatus() == null ^ this.getLineItemCountsByStatus() == null) {
            return false;
        }
        if (other.getLineItemCountsByStatus() != null && !other.getLineItemCountsByStatus().equals(this.getLineItemCountsByStatus())) {
            return false;
        }
        if (other.getOrderSubmissionDate() == null ^ this.getOrderSubmissionDate() == null) {
            return false;
        }
        if (other.getOrderSubmissionDate() != null && !other.getOrderSubmissionDate().equals(this.getOrderSubmissionDate())) {
            return false;
        }
        if (other.getOrderFulfilledDate() == null ^ this.getOrderFulfilledDate() == null) {
            return false;
        }
        return other.getOrderFulfilledDate() == null || other.getOrderFulfilledDate().equals(this.getOrderFulfilledDate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOutpostId() == null ? 0 : this.getOutpostId().hashCode());
        hashCode = 31 * hashCode + (this.getOrderId() == null ? 0 : this.getOrderId().hashCode());
        hashCode = 31 * hashCode + (this.getOrderType() == null ? 0 : this.getOrderType().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getLineItemCountsByStatus() == null ? 0 : this.getLineItemCountsByStatus().hashCode());
        hashCode = 31 * hashCode + (this.getOrderSubmissionDate() == null ? 0 : this.getOrderSubmissionDate().hashCode());
        hashCode = 31 * hashCode + (this.getOrderFulfilledDate() == null ? 0 : this.getOrderFulfilledDate().hashCode());
        return hashCode;
    }

    public OrderSummary clone() {
        try {
            return (OrderSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OrderSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

