/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.osis.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.osis.model.BufferOptions;
import com.amazonaws.services.osis.model.EncryptionAtRestOptions;
import com.amazonaws.services.osis.model.LogPublishingOptions;
import com.amazonaws.services.osis.model.PipelineDestination;
import com.amazonaws.services.osis.model.PipelineStatus;
import com.amazonaws.services.osis.model.PipelineStatusReason;
import com.amazonaws.services.osis.model.ServiceVpcEndpoint;
import com.amazonaws.services.osis.model.Tag;
import com.amazonaws.services.osis.model.VpcEndpoint;
import com.amazonaws.services.osis.model.transform.PipelineMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Pipeline
implements Serializable,
Cloneable,
StructuredPojo {
    private String pipelineName;
    private String pipelineArn;
    private Integer minUnits;
    private Integer maxUnits;
    private String status;
    private PipelineStatusReason statusReason;
    private String pipelineConfigurationBody;
    private Date createdAt;
    private Date lastUpdatedAt;
    private List<String> ingestEndpointUrls;
    private LogPublishingOptions logPublishingOptions;
    private List<VpcEndpoint> vpcEndpoints;
    private BufferOptions bufferOptions;
    private EncryptionAtRestOptions encryptionAtRestOptions;
    private String vpcEndpointService;
    private List<ServiceVpcEndpoint> serviceVpcEndpoints;
    private List<PipelineDestination> destinations;
    private List<Tag> tags;

    public void setPipelineName(String pipelineName) {
        this.pipelineName = pipelineName;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public Pipeline withPipelineName(String pipelineName) {
        this.setPipelineName(pipelineName);
        return this;
    }

    public void setPipelineArn(String pipelineArn) {
        this.pipelineArn = pipelineArn;
    }

    public String getPipelineArn() {
        return this.pipelineArn;
    }

    public Pipeline withPipelineArn(String pipelineArn) {
        this.setPipelineArn(pipelineArn);
        return this;
    }

    public void setMinUnits(Integer minUnits) {
        this.minUnits = minUnits;
    }

    public Integer getMinUnits() {
        return this.minUnits;
    }

    public Pipeline withMinUnits(Integer minUnits) {
        this.setMinUnits(minUnits);
        return this;
    }

    public void setMaxUnits(Integer maxUnits) {
        this.maxUnits = maxUnits;
    }

    public Integer getMaxUnits() {
        return this.maxUnits;
    }

    public Pipeline withMaxUnits(Integer maxUnits) {
        this.setMaxUnits(maxUnits);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Pipeline withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Pipeline withStatus(PipelineStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusReason(PipelineStatusReason statusReason) {
        this.statusReason = statusReason;
    }

    public PipelineStatusReason getStatusReason() {
        return this.statusReason;
    }

    public Pipeline withStatusReason(PipelineStatusReason statusReason) {
        this.setStatusReason(statusReason);
        return this;
    }

    public void setPipelineConfigurationBody(String pipelineConfigurationBody) {
        this.pipelineConfigurationBody = pipelineConfigurationBody;
    }

    public String getPipelineConfigurationBody() {
        return this.pipelineConfigurationBody;
    }

    public Pipeline withPipelineConfigurationBody(String pipelineConfigurationBody) {
        this.setPipelineConfigurationBody(pipelineConfigurationBody);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Pipeline withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setLastUpdatedAt(Date lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public Date getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Pipeline withLastUpdatedAt(Date lastUpdatedAt) {
        this.setLastUpdatedAt(lastUpdatedAt);
        return this;
    }

    public List<String> getIngestEndpointUrls() {
        return this.ingestEndpointUrls;
    }

    public void setIngestEndpointUrls(Collection<String> ingestEndpointUrls) {
        if (ingestEndpointUrls == null) {
            this.ingestEndpointUrls = null;
            return;
        }
        this.ingestEndpointUrls = new ArrayList<String>(ingestEndpointUrls);
    }

    public Pipeline withIngestEndpointUrls(String ... ingestEndpointUrls) {
        if (this.ingestEndpointUrls == null) {
            this.setIngestEndpointUrls(new ArrayList<String>(ingestEndpointUrls.length));
        }
        for (String ele : ingestEndpointUrls) {
            this.ingestEndpointUrls.add(ele);
        }
        return this;
    }

    public Pipeline withIngestEndpointUrls(Collection<String> ingestEndpointUrls) {
        this.setIngestEndpointUrls(ingestEndpointUrls);
        return this;
    }

    public void setLogPublishingOptions(LogPublishingOptions logPublishingOptions) {
        this.logPublishingOptions = logPublishingOptions;
    }

    public LogPublishingOptions getLogPublishingOptions() {
        return this.logPublishingOptions;
    }

    public Pipeline withLogPublishingOptions(LogPublishingOptions logPublishingOptions) {
        this.setLogPublishingOptions(logPublishingOptions);
        return this;
    }

    public List<VpcEndpoint> getVpcEndpoints() {
        return this.vpcEndpoints;
    }

    public void setVpcEndpoints(Collection<VpcEndpoint> vpcEndpoints) {
        if (vpcEndpoints == null) {
            this.vpcEndpoints = null;
            return;
        }
        this.vpcEndpoints = new ArrayList<VpcEndpoint>(vpcEndpoints);
    }

    public Pipeline withVpcEndpoints(VpcEndpoint ... vpcEndpoints) {
        if (this.vpcEndpoints == null) {
            this.setVpcEndpoints(new ArrayList<VpcEndpoint>(vpcEndpoints.length));
        }
        for (VpcEndpoint ele : vpcEndpoints) {
            this.vpcEndpoints.add(ele);
        }
        return this;
    }

    public Pipeline withVpcEndpoints(Collection<VpcEndpoint> vpcEndpoints) {
        this.setVpcEndpoints(vpcEndpoints);
        return this;
    }

    public void setBufferOptions(BufferOptions bufferOptions) {
        this.bufferOptions = bufferOptions;
    }

    public BufferOptions getBufferOptions() {
        return this.bufferOptions;
    }

    public Pipeline withBufferOptions(BufferOptions bufferOptions) {
        this.setBufferOptions(bufferOptions);
        return this;
    }

    public void setEncryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
        this.encryptionAtRestOptions = encryptionAtRestOptions;
    }

    public EncryptionAtRestOptions getEncryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    public Pipeline withEncryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
        this.setEncryptionAtRestOptions(encryptionAtRestOptions);
        return this;
    }

    public void setVpcEndpointService(String vpcEndpointService) {
        this.vpcEndpointService = vpcEndpointService;
    }

    public String getVpcEndpointService() {
        return this.vpcEndpointService;
    }

    public Pipeline withVpcEndpointService(String vpcEndpointService) {
        this.setVpcEndpointService(vpcEndpointService);
        return this;
    }

    public List<ServiceVpcEndpoint> getServiceVpcEndpoints() {
        return this.serviceVpcEndpoints;
    }

    public void setServiceVpcEndpoints(Collection<ServiceVpcEndpoint> serviceVpcEndpoints) {
        if (serviceVpcEndpoints == null) {
            this.serviceVpcEndpoints = null;
            return;
        }
        this.serviceVpcEndpoints = new ArrayList<ServiceVpcEndpoint>(serviceVpcEndpoints);
    }

    public Pipeline withServiceVpcEndpoints(ServiceVpcEndpoint ... serviceVpcEndpoints) {
        if (this.serviceVpcEndpoints == null) {
            this.setServiceVpcEndpoints(new ArrayList<ServiceVpcEndpoint>(serviceVpcEndpoints.length));
        }
        for (ServiceVpcEndpoint ele : serviceVpcEndpoints) {
            this.serviceVpcEndpoints.add(ele);
        }
        return this;
    }

    public Pipeline withServiceVpcEndpoints(Collection<ServiceVpcEndpoint> serviceVpcEndpoints) {
        this.setServiceVpcEndpoints(serviceVpcEndpoints);
        return this;
    }

    public List<PipelineDestination> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<PipelineDestination> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<PipelineDestination>(destinations);
    }

    public Pipeline withDestinations(PipelineDestination ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<PipelineDestination>(destinations.length));
        }
        for (PipelineDestination ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public Pipeline withDestinations(Collection<PipelineDestination> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public Pipeline withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Pipeline withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineName() != null) {
            sb.append("PipelineName: ").append(this.getPipelineName()).append(",");
        }
        if (this.getPipelineArn() != null) {
            sb.append("PipelineArn: ").append(this.getPipelineArn()).append(",");
        }
        if (this.getMinUnits() != null) {
            sb.append("MinUnits: ").append(this.getMinUnits()).append(",");
        }
        if (this.getMaxUnits() != null) {
            sb.append("MaxUnits: ").append(this.getMaxUnits()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusReason() != null) {
            sb.append("StatusReason: ").append(this.getStatusReason()).append(",");
        }
        if (this.getPipelineConfigurationBody() != null) {
            sb.append("PipelineConfigurationBody: ").append(this.getPipelineConfigurationBody()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getLastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(this.getLastUpdatedAt()).append(",");
        }
        if (this.getIngestEndpointUrls() != null) {
            sb.append("IngestEndpointUrls: ").append(this.getIngestEndpointUrls()).append(",");
        }
        if (this.getLogPublishingOptions() != null) {
            sb.append("LogPublishingOptions: ").append(this.getLogPublishingOptions()).append(",");
        }
        if (this.getVpcEndpoints() != null) {
            sb.append("VpcEndpoints: ").append(this.getVpcEndpoints()).append(",");
        }
        if (this.getBufferOptions() != null) {
            sb.append("BufferOptions: ").append(this.getBufferOptions()).append(",");
        }
        if (this.getEncryptionAtRestOptions() != null) {
            sb.append("EncryptionAtRestOptions: ").append(this.getEncryptionAtRestOptions()).append(",");
        }
        if (this.getVpcEndpointService() != null) {
            sb.append("VpcEndpointService: ").append(this.getVpcEndpointService()).append(",");
        }
        if (this.getServiceVpcEndpoints() != null) {
            sb.append("ServiceVpcEndpoints: ").append(this.getServiceVpcEndpoints()).append(",");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pipeline)) {
            return false;
        }
        Pipeline other = (Pipeline)obj;
        if (other.getPipelineName() == null ^ this.getPipelineName() == null) {
            return false;
        }
        if (other.getPipelineName() != null && !other.getPipelineName().equals(this.getPipelineName())) {
            return false;
        }
        if (other.getPipelineArn() == null ^ this.getPipelineArn() == null) {
            return false;
        }
        if (other.getPipelineArn() != null && !other.getPipelineArn().equals(this.getPipelineArn())) {
            return false;
        }
        if (other.getMinUnits() == null ^ this.getMinUnits() == null) {
            return false;
        }
        if (other.getMinUnits() != null && !other.getMinUnits().equals(this.getMinUnits())) {
            return false;
        }
        if (other.getMaxUnits() == null ^ this.getMaxUnits() == null) {
            return false;
        }
        if (other.getMaxUnits() != null && !other.getMaxUnits().equals(this.getMaxUnits())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusReason() == null ^ this.getStatusReason() == null) {
            return false;
        }
        if (other.getStatusReason() != null && !other.getStatusReason().equals(this.getStatusReason())) {
            return false;
        }
        if (other.getPipelineConfigurationBody() == null ^ this.getPipelineConfigurationBody() == null) {
            return false;
        }
        if (other.getPipelineConfigurationBody() != null && !other.getPipelineConfigurationBody().equals(this.getPipelineConfigurationBody())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getLastUpdatedAt() == null ^ this.getLastUpdatedAt() == null) {
            return false;
        }
        if (other.getLastUpdatedAt() != null && !other.getLastUpdatedAt().equals(this.getLastUpdatedAt())) {
            return false;
        }
        if (other.getIngestEndpointUrls() == null ^ this.getIngestEndpointUrls() == null) {
            return false;
        }
        if (other.getIngestEndpointUrls() != null && !other.getIngestEndpointUrls().equals(this.getIngestEndpointUrls())) {
            return false;
        }
        if (other.getLogPublishingOptions() == null ^ this.getLogPublishingOptions() == null) {
            return false;
        }
        if (other.getLogPublishingOptions() != null && !other.getLogPublishingOptions().equals(this.getLogPublishingOptions())) {
            return false;
        }
        if (other.getVpcEndpoints() == null ^ this.getVpcEndpoints() == null) {
            return false;
        }
        if (other.getVpcEndpoints() != null && !other.getVpcEndpoints().equals(this.getVpcEndpoints())) {
            return false;
        }
        if (other.getBufferOptions() == null ^ this.getBufferOptions() == null) {
            return false;
        }
        if (other.getBufferOptions() != null && !other.getBufferOptions().equals(this.getBufferOptions())) {
            return false;
        }
        if (other.getEncryptionAtRestOptions() == null ^ this.getEncryptionAtRestOptions() == null) {
            return false;
        }
        if (other.getEncryptionAtRestOptions() != null && !other.getEncryptionAtRestOptions().equals(this.getEncryptionAtRestOptions())) {
            return false;
        }
        if (other.getVpcEndpointService() == null ^ this.getVpcEndpointService() == null) {
            return false;
        }
        if (other.getVpcEndpointService() != null && !other.getVpcEndpointService().equals(this.getVpcEndpointService())) {
            return false;
        }
        if (other.getServiceVpcEndpoints() == null ^ this.getServiceVpcEndpoints() == null) {
            return false;
        }
        if (other.getServiceVpcEndpoints() != null && !other.getServiceVpcEndpoints().equals(this.getServiceVpcEndpoints())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineName() == null ? 0 : this.getPipelineName().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineArn() == null ? 0 : this.getPipelineArn().hashCode());
        hashCode = 31 * hashCode + (this.getMinUnits() == null ? 0 : this.getMinUnits().hashCode());
        hashCode = 31 * hashCode + (this.getMaxUnits() == null ? 0 : this.getMaxUnits().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusReason() == null ? 0 : this.getStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineConfigurationBody() == null ? 0 : this.getPipelineConfigurationBody().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedAt() == null ? 0 : this.getLastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getIngestEndpointUrls() == null ? 0 : this.getIngestEndpointUrls().hashCode());
        hashCode = 31 * hashCode + (this.getLogPublishingOptions() == null ? 0 : this.getLogPublishingOptions().hashCode());
        hashCode = 31 * hashCode + (this.getVpcEndpoints() == null ? 0 : this.getVpcEndpoints().hashCode());
        hashCode = 31 * hashCode + (this.getBufferOptions() == null ? 0 : this.getBufferOptions().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionAtRestOptions() == null ? 0 : this.getEncryptionAtRestOptions().hashCode());
        hashCode = 31 * hashCode + (this.getVpcEndpointService() == null ? 0 : this.getVpcEndpointService().hashCode());
        hashCode = 31 * hashCode + (this.getServiceVpcEndpoints() == null ? 0 : this.getServiceVpcEndpoints().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Pipeline clone() {
        try {
            return (Pipeline)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

