/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkmanager.model.Attachment;
import com.amazonaws.services.networkmanager.model.VpcOptions;
import com.amazonaws.services.networkmanager.model.transform.VpcAttachmentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VpcAttachment
implements Serializable,
Cloneable,
StructuredPojo {
    private Attachment attachment;
    private List<String> subnetArns;
    private VpcOptions options;

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public VpcAttachment withAttachment(Attachment attachment) {
        this.setAttachment(attachment);
        return this;
    }

    public List<String> getSubnetArns() {
        return this.subnetArns;
    }

    public void setSubnetArns(Collection<String> subnetArns) {
        if (subnetArns == null) {
            this.subnetArns = null;
            return;
        }
        this.subnetArns = new ArrayList<String>(subnetArns);
    }

    public VpcAttachment withSubnetArns(String ... subnetArns) {
        if (this.subnetArns == null) {
            this.setSubnetArns(new ArrayList<String>(subnetArns.length));
        }
        for (String ele : subnetArns) {
            this.subnetArns.add(ele);
        }
        return this;
    }

    public VpcAttachment withSubnetArns(Collection<String> subnetArns) {
        this.setSubnetArns(subnetArns);
        return this;
    }

    public void setOptions(VpcOptions options) {
        this.options = options;
    }

    public VpcOptions getOptions() {
        return this.options;
    }

    public VpcAttachment withOptions(VpcOptions options) {
        this.setOptions(options);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttachment() != null) {
            sb.append("Attachment: ").append(this.getAttachment()).append(",");
        }
        if (this.getSubnetArns() != null) {
            sb.append("SubnetArns: ").append(this.getSubnetArns()).append(",");
        }
        if (this.getOptions() != null) {
            sb.append("Options: ").append(this.getOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcAttachment)) {
            return false;
        }
        VpcAttachment other = (VpcAttachment)obj;
        if (other.getAttachment() == null ^ this.getAttachment() == null) {
            return false;
        }
        if (other.getAttachment() != null && !other.getAttachment().equals(this.getAttachment())) {
            return false;
        }
        if (other.getSubnetArns() == null ^ this.getSubnetArns() == null) {
            return false;
        }
        if (other.getSubnetArns() != null && !other.getSubnetArns().equals(this.getSubnetArns())) {
            return false;
        }
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        return other.getOptions() == null || other.getOptions().equals(this.getOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttachment() == null ? 0 : this.getAttachment().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetArns() == null ? 0 : this.getSubnetArns().hashCode());
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        return hashCode;
    }

    public VpcAttachment clone() {
        try {
            return (VpcAttachment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VpcAttachmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

