/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkfirewall.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkfirewall.model.CheckCertificateRevocationStatusActions;
import com.amazonaws.services.networkfirewall.model.ServerCertificate;
import com.amazonaws.services.networkfirewall.model.ServerCertificateScope;
import com.amazonaws.services.networkfirewall.model.transform.ServerCertificateConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ServerCertificateConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ServerCertificate> serverCertificates;
    private List<ServerCertificateScope> scopes;
    private String certificateAuthorityArn;
    private CheckCertificateRevocationStatusActions checkCertificateRevocationStatus;

    public List<ServerCertificate> getServerCertificates() {
        return this.serverCertificates;
    }

    public void setServerCertificates(Collection<ServerCertificate> serverCertificates) {
        if (serverCertificates == null) {
            this.serverCertificates = null;
            return;
        }
        this.serverCertificates = new ArrayList<ServerCertificate>(serverCertificates);
    }

    public ServerCertificateConfiguration withServerCertificates(ServerCertificate ... serverCertificates) {
        if (this.serverCertificates == null) {
            this.setServerCertificates(new ArrayList<ServerCertificate>(serverCertificates.length));
        }
        for (ServerCertificate ele : serverCertificates) {
            this.serverCertificates.add(ele);
        }
        return this;
    }

    public ServerCertificateConfiguration withServerCertificates(Collection<ServerCertificate> serverCertificates) {
        this.setServerCertificates(serverCertificates);
        return this;
    }

    public List<ServerCertificateScope> getScopes() {
        return this.scopes;
    }

    public void setScopes(Collection<ServerCertificateScope> scopes) {
        if (scopes == null) {
            this.scopes = null;
            return;
        }
        this.scopes = new ArrayList<ServerCertificateScope>(scopes);
    }

    public ServerCertificateConfiguration withScopes(ServerCertificateScope ... scopes) {
        if (this.scopes == null) {
            this.setScopes(new ArrayList<ServerCertificateScope>(scopes.length));
        }
        for (ServerCertificateScope ele : scopes) {
            this.scopes.add(ele);
        }
        return this;
    }

    public ServerCertificateConfiguration withScopes(Collection<ServerCertificateScope> scopes) {
        this.setScopes(scopes);
        return this;
    }

    public void setCertificateAuthorityArn(String certificateAuthorityArn) {
        this.certificateAuthorityArn = certificateAuthorityArn;
    }

    public String getCertificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public ServerCertificateConfiguration withCertificateAuthorityArn(String certificateAuthorityArn) {
        this.setCertificateAuthorityArn(certificateAuthorityArn);
        return this;
    }

    public void setCheckCertificateRevocationStatus(CheckCertificateRevocationStatusActions checkCertificateRevocationStatus) {
        this.checkCertificateRevocationStatus = checkCertificateRevocationStatus;
    }

    public CheckCertificateRevocationStatusActions getCheckCertificateRevocationStatus() {
        return this.checkCertificateRevocationStatus;
    }

    public ServerCertificateConfiguration withCheckCertificateRevocationStatus(CheckCertificateRevocationStatusActions checkCertificateRevocationStatus) {
        this.setCheckCertificateRevocationStatus(checkCertificateRevocationStatus);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServerCertificates() != null) {
            sb.append("ServerCertificates: ").append(this.getServerCertificates()).append(",");
        }
        if (this.getScopes() != null) {
            sb.append("Scopes: ").append(this.getScopes()).append(",");
        }
        if (this.getCertificateAuthorityArn() != null) {
            sb.append("CertificateAuthorityArn: ").append(this.getCertificateAuthorityArn()).append(",");
        }
        if (this.getCheckCertificateRevocationStatus() != null) {
            sb.append("CheckCertificateRevocationStatus: ").append(this.getCheckCertificateRevocationStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerCertificateConfiguration)) {
            return false;
        }
        ServerCertificateConfiguration other = (ServerCertificateConfiguration)obj;
        if (other.getServerCertificates() == null ^ this.getServerCertificates() == null) {
            return false;
        }
        if (other.getServerCertificates() != null && !other.getServerCertificates().equals(this.getServerCertificates())) {
            return false;
        }
        if (other.getScopes() == null ^ this.getScopes() == null) {
            return false;
        }
        if (other.getScopes() != null && !other.getScopes().equals(this.getScopes())) {
            return false;
        }
        if (other.getCertificateAuthorityArn() == null ^ this.getCertificateAuthorityArn() == null) {
            return false;
        }
        if (other.getCertificateAuthorityArn() != null && !other.getCertificateAuthorityArn().equals(this.getCertificateAuthorityArn())) {
            return false;
        }
        if (other.getCheckCertificateRevocationStatus() == null ^ this.getCheckCertificateRevocationStatus() == null) {
            return false;
        }
        return other.getCheckCertificateRevocationStatus() == null || other.getCheckCertificateRevocationStatus().equals(this.getCheckCertificateRevocationStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServerCertificates() == null ? 0 : this.getServerCertificates().hashCode());
        hashCode = 31 * hashCode + (this.getScopes() == null ? 0 : this.getScopes().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateAuthorityArn() == null ? 0 : this.getCertificateAuthorityArn().hashCode());
        hashCode = 31 * hashCode + (this.getCheckCertificateRevocationStatus() == null ? 0 : this.getCheckCertificateRevocationStatus().hashCode());
        return hashCode;
    }

    public ServerCertificateConfiguration clone() {
        try {
            return (ServerCertificateConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServerCertificateConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

