/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptune.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.neptune.model.ModifyDBClusterEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyDBClusterEndpointRequestMarshaller
implements Marshaller<Request<ModifyDBClusterEndpointRequest>, ModifyDBClusterEndpointRequest> {
    public Request<ModifyDBClusterEndpointRequest> marshall(ModifyDBClusterEndpointRequest modifyDBClusterEndpointRequest) {
        if (modifyDBClusterEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyDBClusterEndpointRequest, "AmazonNeptune");
        request.addParameter("Action", "ModifyDBClusterEndpoint");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBClusterEndpointRequest.getDBClusterEndpointIdentifier() != null) {
            request.addParameter("DBClusterEndpointIdentifier", StringUtils.fromString((String)modifyDBClusterEndpointRequest.getDBClusterEndpointIdentifier()));
        }
        if (modifyDBClusterEndpointRequest.getEndpointType() != null) {
            request.addParameter("EndpointType", StringUtils.fromString((String)modifyDBClusterEndpointRequest.getEndpointType()));
        }
        if (modifyDBClusterEndpointRequest.getStaticMembers() != null) {
            List<String> staticMembersList = modifyDBClusterEndpointRequest.getStaticMembers();
            if (staticMembersList.isEmpty()) {
                request.addParameter("StaticMembers", "");
            } else {
                int staticMembersListIndex = 1;
                for (String staticMembersListValue : staticMembersList) {
                    if (staticMembersListValue != null) {
                        request.addParameter("StaticMembers.member." + staticMembersListIndex, StringUtils.fromString((String)staticMembersListValue));
                    }
                    ++staticMembersListIndex;
                }
            }
        }
        if (modifyDBClusterEndpointRequest.getExcludedMembers() != null) {
            List<String> excludedMembersList = modifyDBClusterEndpointRequest.getExcludedMembers();
            if (excludedMembersList.isEmpty()) {
                request.addParameter("ExcludedMembers", "");
            } else {
                int excludedMembersListIndex = 1;
                for (String excludedMembersListValue : excludedMembersList) {
                    if (excludedMembersListValue != null) {
                        request.addParameter("ExcludedMembers.member." + excludedMembersListIndex, StringUtils.fromString((String)excludedMembersListValue));
                    }
                    ++excludedMembersListIndex;
                }
            }
        }
        return request;
    }
}

