/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptune.model.transform;

import com.amazonaws.services.neptune.model.EventCategoriesMap;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class EventCategoriesMapStaxUnmarshaller
implements Unmarshaller<EventCategoriesMap, StaxUnmarshallerContext> {
    private static EventCategoriesMapStaxUnmarshaller instance;

    public EventCategoriesMap unmarshall(StaxUnmarshallerContext context) throws Exception {
        EventCategoriesMap eventCategoriesMap = new EventCategoriesMap();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return eventCategoriesMap;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SourceType", targetDepth)) {
                    eventCategoriesMap.setSourceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EventCategories", targetDepth)) {
                    eventCategoriesMap.withEventCategories(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("EventCategories/EventCategory", targetDepth)) continue;
                eventCategoriesMap.withEventCategories(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return eventCategoriesMap;
    }

    public static EventCategoriesMapStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EventCategoriesMapStaxUnmarshaller();
        }
        return instance;
    }
}

