/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptune.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.neptune.model.DescribeDBClusterEndpointsRequest;
import com.amazonaws.services.neptune.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeDBClusterEndpointsRequestMarshaller
implements Marshaller<Request<DescribeDBClusterEndpointsRequest>, DescribeDBClusterEndpointsRequest> {
    public Request<DescribeDBClusterEndpointsRequest> marshall(DescribeDBClusterEndpointsRequest describeDBClusterEndpointsRequest) {
        if (describeDBClusterEndpointsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBClusterEndpointsRequest, "AmazonNeptune");
        request.addParameter("Action", "DescribeDBClusterEndpoints");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBClusterEndpointsRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)describeDBClusterEndpointsRequest.getDBClusterIdentifier()));
        }
        if (describeDBClusterEndpointsRequest.getDBClusterEndpointIdentifier() != null) {
            request.addParameter("DBClusterEndpointIdentifier", StringUtils.fromString((String)describeDBClusterEndpointsRequest.getDBClusterEndpointIdentifier()));
        }
        if (describeDBClusterEndpointsRequest.getFilters() != null) {
            List<Filter> filtersList = describeDBClusterEndpointsRequest.getFilters();
            if (filtersList.isEmpty()) {
                request.addParameter("Filters", "");
            } else {
                int filtersListIndex = 1;
                for (Filter filtersListValue : filtersList) {
                    if (filtersListValue != null) {
                        if (filtersListValue.getName() != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                        }
                        if (filtersListValue.getValues() != null) {
                            List<String> valuesList = filtersListValue.getValues();
                            if (valuesList.isEmpty()) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                            } else {
                                int valuesListIndex = 1;
                                for (String valuesListValue : valuesList) {
                                    if (valuesListValue != null) {
                                        request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                    }
                                    ++valuesListIndex;
                                }
                            }
                        }
                    }
                    ++filtersListIndex;
                }
            }
        }
        if (describeDBClusterEndpointsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBClusterEndpointsRequest.getMaxRecords()));
        }
        if (describeDBClusterEndpointsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBClusterEndpointsRequest.getMarker()));
        }
        return request;
    }
}

