/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.migrationhubstrategyrecommendations;

import javax.annotation.Generated;

import com.amazonaws.services.migrationhubstrategyrecommendations.model.*;

/**
 * Abstract implementation of {@code AWSMigrationHubStrategyRecommendationsAsync}. Convenient method forms pass through
 * to the corresponding overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSMigrationHubStrategyRecommendationsAsync extends AbstractAWSMigrationHubStrategyRecommendations implements
        AWSMigrationHubStrategyRecommendationsAsync {

    protected AbstractAWSMigrationHubStrategyRecommendationsAsync() {
    }

    @Override
    public java.util.concurrent.Future<GetApplicationComponentDetailsResult> getApplicationComponentDetailsAsync(GetApplicationComponentDetailsRequest request) {

        return getApplicationComponentDetailsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetApplicationComponentDetailsResult> getApplicationComponentDetailsAsync(GetApplicationComponentDetailsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetApplicationComponentDetailsRequest, GetApplicationComponentDetailsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetApplicationComponentStrategiesResult> getApplicationComponentStrategiesAsync(
            GetApplicationComponentStrategiesRequest request) {

        return getApplicationComponentStrategiesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetApplicationComponentStrategiesResult> getApplicationComponentStrategiesAsync(
            GetApplicationComponentStrategiesRequest request,
            com.amazonaws.handlers.AsyncHandler<GetApplicationComponentStrategiesRequest, GetApplicationComponentStrategiesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAssessmentResult> getAssessmentAsync(GetAssessmentRequest request) {

        return getAssessmentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAssessmentResult> getAssessmentAsync(GetAssessmentRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAssessmentRequest, GetAssessmentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetImportFileTaskResult> getImportFileTaskAsync(GetImportFileTaskRequest request) {

        return getImportFileTaskAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetImportFileTaskResult> getImportFileTaskAsync(GetImportFileTaskRequest request,
            com.amazonaws.handlers.AsyncHandler<GetImportFileTaskRequest, GetImportFileTaskResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetLatestAssessmentIdResult> getLatestAssessmentIdAsync(GetLatestAssessmentIdRequest request) {

        return getLatestAssessmentIdAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetLatestAssessmentIdResult> getLatestAssessmentIdAsync(GetLatestAssessmentIdRequest request,
            com.amazonaws.handlers.AsyncHandler<GetLatestAssessmentIdRequest, GetLatestAssessmentIdResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetPortfolioPreferencesResult> getPortfolioPreferencesAsync(GetPortfolioPreferencesRequest request) {

        return getPortfolioPreferencesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetPortfolioPreferencesResult> getPortfolioPreferencesAsync(GetPortfolioPreferencesRequest request,
            com.amazonaws.handlers.AsyncHandler<GetPortfolioPreferencesRequest, GetPortfolioPreferencesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetPortfolioSummaryResult> getPortfolioSummaryAsync(GetPortfolioSummaryRequest request) {

        return getPortfolioSummaryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetPortfolioSummaryResult> getPortfolioSummaryAsync(GetPortfolioSummaryRequest request,
            com.amazonaws.handlers.AsyncHandler<GetPortfolioSummaryRequest, GetPortfolioSummaryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetRecommendationReportDetailsResult> getRecommendationReportDetailsAsync(GetRecommendationReportDetailsRequest request) {

        return getRecommendationReportDetailsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetRecommendationReportDetailsResult> getRecommendationReportDetailsAsync(GetRecommendationReportDetailsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetRecommendationReportDetailsRequest, GetRecommendationReportDetailsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetServerDetailsResult> getServerDetailsAsync(GetServerDetailsRequest request) {

        return getServerDetailsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetServerDetailsResult> getServerDetailsAsync(GetServerDetailsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetServerDetailsRequest, GetServerDetailsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetServerStrategiesResult> getServerStrategiesAsync(GetServerStrategiesRequest request) {

        return getServerStrategiesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetServerStrategiesResult> getServerStrategiesAsync(GetServerStrategiesRequest request,
            com.amazonaws.handlers.AsyncHandler<GetServerStrategiesRequest, GetServerStrategiesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAnalyzableServersResult> listAnalyzableServersAsync(ListAnalyzableServersRequest request) {

        return listAnalyzableServersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAnalyzableServersResult> listAnalyzableServersAsync(ListAnalyzableServersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAnalyzableServersRequest, ListAnalyzableServersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListApplicationComponentsResult> listApplicationComponentsAsync(ListApplicationComponentsRequest request) {

        return listApplicationComponentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListApplicationComponentsResult> listApplicationComponentsAsync(ListApplicationComponentsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListApplicationComponentsRequest, ListApplicationComponentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListCollectorsResult> listCollectorsAsync(ListCollectorsRequest request) {

        return listCollectorsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListCollectorsResult> listCollectorsAsync(ListCollectorsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListCollectorsRequest, ListCollectorsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListImportFileTaskResult> listImportFileTaskAsync(ListImportFileTaskRequest request) {

        return listImportFileTaskAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListImportFileTaskResult> listImportFileTaskAsync(ListImportFileTaskRequest request,
            com.amazonaws.handlers.AsyncHandler<ListImportFileTaskRequest, ListImportFileTaskResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListServersResult> listServersAsync(ListServersRequest request) {

        return listServersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListServersResult> listServersAsync(ListServersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListServersRequest, ListServersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutPortfolioPreferencesResult> putPortfolioPreferencesAsync(PutPortfolioPreferencesRequest request) {

        return putPortfolioPreferencesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutPortfolioPreferencesResult> putPortfolioPreferencesAsync(PutPortfolioPreferencesRequest request,
            com.amazonaws.handlers.AsyncHandler<PutPortfolioPreferencesRequest, PutPortfolioPreferencesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartAssessmentResult> startAssessmentAsync(StartAssessmentRequest request) {

        return startAssessmentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartAssessmentResult> startAssessmentAsync(StartAssessmentRequest request,
            com.amazonaws.handlers.AsyncHandler<StartAssessmentRequest, StartAssessmentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartImportFileTaskResult> startImportFileTaskAsync(StartImportFileTaskRequest request) {

        return startImportFileTaskAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartImportFileTaskResult> startImportFileTaskAsync(StartImportFileTaskRequest request,
            com.amazonaws.handlers.AsyncHandler<StartImportFileTaskRequest, StartImportFileTaskResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartRecommendationReportGenerationResult> startRecommendationReportGenerationAsync(
            StartRecommendationReportGenerationRequest request) {

        return startRecommendationReportGenerationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartRecommendationReportGenerationResult> startRecommendationReportGenerationAsync(
            StartRecommendationReportGenerationRequest request,
            com.amazonaws.handlers.AsyncHandler<StartRecommendationReportGenerationRequest, StartRecommendationReportGenerationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StopAssessmentResult> stopAssessmentAsync(StopAssessmentRequest request) {

        return stopAssessmentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StopAssessmentResult> stopAssessmentAsync(StopAssessmentRequest request,
            com.amazonaws.handlers.AsyncHandler<StopAssessmentRequest, StopAssessmentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateApplicationComponentConfigResult> updateApplicationComponentConfigAsync(
            UpdateApplicationComponentConfigRequest request) {

        return updateApplicationComponentConfigAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateApplicationComponentConfigResult> updateApplicationComponentConfigAsync(
            UpdateApplicationComponentConfigRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateApplicationComponentConfigRequest, UpdateApplicationComponentConfigResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateServerConfigResult> updateServerConfigAsync(UpdateServerConfigRequest request) {

        return updateServerConfigAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateServerConfigResult> updateServerConfigAsync(UpdateServerConfigRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateServerConfigRequest, UpdateServerConfigResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
