/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.migrationhubrefactorspaces.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.migrationhubrefactorspaces.model.HttpMethod;
import com.amazonaws.services.migrationhubrefactorspaces.model.RouteActivationState;
import com.amazonaws.services.migrationhubrefactorspaces.model.transform.UriPathRouteInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UriPathRouteInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String activationState;
    private Boolean appendSourcePath;
    private Boolean includeChildPaths;
    private List<String> methods;
    private String sourcePath;

    public void setActivationState(String activationState) {
        this.activationState = activationState;
    }

    public String getActivationState() {
        return this.activationState;
    }

    public UriPathRouteInput withActivationState(String activationState) {
        this.setActivationState(activationState);
        return this;
    }

    public UriPathRouteInput withActivationState(RouteActivationState activationState) {
        this.activationState = activationState.toString();
        return this;
    }

    public void setAppendSourcePath(Boolean appendSourcePath) {
        this.appendSourcePath = appendSourcePath;
    }

    public Boolean getAppendSourcePath() {
        return this.appendSourcePath;
    }

    public UriPathRouteInput withAppendSourcePath(Boolean appendSourcePath) {
        this.setAppendSourcePath(appendSourcePath);
        return this;
    }

    public Boolean isAppendSourcePath() {
        return this.appendSourcePath;
    }

    public void setIncludeChildPaths(Boolean includeChildPaths) {
        this.includeChildPaths = includeChildPaths;
    }

    public Boolean getIncludeChildPaths() {
        return this.includeChildPaths;
    }

    public UriPathRouteInput withIncludeChildPaths(Boolean includeChildPaths) {
        this.setIncludeChildPaths(includeChildPaths);
        return this;
    }

    public Boolean isIncludeChildPaths() {
        return this.includeChildPaths;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public void setMethods(Collection<String> methods) {
        if (methods == null) {
            this.methods = null;
            return;
        }
        this.methods = new ArrayList<String>(methods);
    }

    public UriPathRouteInput withMethods(String ... methods) {
        if (this.methods == null) {
            this.setMethods(new ArrayList<String>(methods.length));
        }
        for (String ele : methods) {
            this.methods.add(ele);
        }
        return this;
    }

    public UriPathRouteInput withMethods(Collection<String> methods) {
        this.setMethods(methods);
        return this;
    }

    public UriPathRouteInput withMethods(HttpMethod ... methods) {
        ArrayList<String> methodsCopy = new ArrayList<String>(methods.length);
        for (HttpMethod value : methods) {
            methodsCopy.add(value.toString());
        }
        if (this.getMethods() == null) {
            this.setMethods(methodsCopy);
        } else {
            this.getMethods().addAll(methodsCopy);
        }
        return this;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public UriPathRouteInput withSourcePath(String sourcePath) {
        this.setSourcePath(sourcePath);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActivationState() != null) {
            sb.append("ActivationState: ").append(this.getActivationState()).append(",");
        }
        if (this.getAppendSourcePath() != null) {
            sb.append("AppendSourcePath: ").append(this.getAppendSourcePath()).append(",");
        }
        if (this.getIncludeChildPaths() != null) {
            sb.append("IncludeChildPaths: ").append(this.getIncludeChildPaths()).append(",");
        }
        if (this.getMethods() != null) {
            sb.append("Methods: ").append(this.getMethods()).append(",");
        }
        if (this.getSourcePath() != null) {
            sb.append("SourcePath: ").append(this.getSourcePath());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UriPathRouteInput)) {
            return false;
        }
        UriPathRouteInput other = (UriPathRouteInput)obj;
        if (other.getActivationState() == null ^ this.getActivationState() == null) {
            return false;
        }
        if (other.getActivationState() != null && !other.getActivationState().equals(this.getActivationState())) {
            return false;
        }
        if (other.getAppendSourcePath() == null ^ this.getAppendSourcePath() == null) {
            return false;
        }
        if (other.getAppendSourcePath() != null && !other.getAppendSourcePath().equals(this.getAppendSourcePath())) {
            return false;
        }
        if (other.getIncludeChildPaths() == null ^ this.getIncludeChildPaths() == null) {
            return false;
        }
        if (other.getIncludeChildPaths() != null && !other.getIncludeChildPaths().equals(this.getIncludeChildPaths())) {
            return false;
        }
        if (other.getMethods() == null ^ this.getMethods() == null) {
            return false;
        }
        if (other.getMethods() != null && !other.getMethods().equals(this.getMethods())) {
            return false;
        }
        if (other.getSourcePath() == null ^ this.getSourcePath() == null) {
            return false;
        }
        return other.getSourcePath() == null || other.getSourcePath().equals(this.getSourcePath());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActivationState() == null ? 0 : this.getActivationState().hashCode());
        hashCode = 31 * hashCode + (this.getAppendSourcePath() == null ? 0 : this.getAppendSourcePath().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeChildPaths() == null ? 0 : this.getIncludeChildPaths().hashCode());
        hashCode = 31 * hashCode + (this.getMethods() == null ? 0 : this.getMethods().hashCode());
        hashCode = 31 * hashCode + (this.getSourcePath() == null ? 0 : this.getSourcePath().hashCode());
        return hashCode;
    }

    public UriPathRouteInput clone() {
        try {
            return (UriPathRouteInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UriPathRouteInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

