/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mgn.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mgn.model.InitiatedBy;
import com.amazonaws.services.mgn.model.JobStatus;
import com.amazonaws.services.mgn.model.JobType;
import com.amazonaws.services.mgn.model.ParticipatingServer;
import com.amazonaws.services.mgn.model.transform.JobMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Job
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String creationDateTime;
    private String endDateTime;
    private String initiatedBy;
    private String jobID;
    private List<ParticipatingServer> participatingServers;
    private String status;
    private Map<String, String> tags;
    private String type;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Job withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setCreationDateTime(String creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public String getCreationDateTime() {
        return this.creationDateTime;
    }

    public Job withCreationDateTime(String creationDateTime) {
        this.setCreationDateTime(creationDateTime);
        return this;
    }

    public void setEndDateTime(String endDateTime) {
        this.endDateTime = endDateTime;
    }

    public String getEndDateTime() {
        return this.endDateTime;
    }

    public Job withEndDateTime(String endDateTime) {
        this.setEndDateTime(endDateTime);
        return this;
    }

    public void setInitiatedBy(String initiatedBy) {
        this.initiatedBy = initiatedBy;
    }

    public String getInitiatedBy() {
        return this.initiatedBy;
    }

    public Job withInitiatedBy(String initiatedBy) {
        this.setInitiatedBy(initiatedBy);
        return this;
    }

    public Job withInitiatedBy(InitiatedBy initiatedBy) {
        this.initiatedBy = initiatedBy.toString();
        return this;
    }

    public void setJobID(String jobID) {
        this.jobID = jobID;
    }

    public String getJobID() {
        return this.jobID;
    }

    public Job withJobID(String jobID) {
        this.setJobID(jobID);
        return this;
    }

    public List<ParticipatingServer> getParticipatingServers() {
        return this.participatingServers;
    }

    public void setParticipatingServers(Collection<ParticipatingServer> participatingServers) {
        if (participatingServers == null) {
            this.participatingServers = null;
            return;
        }
        this.participatingServers = new ArrayList<ParticipatingServer>(participatingServers);
    }

    public Job withParticipatingServers(ParticipatingServer ... participatingServers) {
        if (this.participatingServers == null) {
            this.setParticipatingServers(new ArrayList<ParticipatingServer>(participatingServers.length));
        }
        for (ParticipatingServer ele : participatingServers) {
            this.participatingServers.add(ele);
        }
        return this;
    }

    public Job withParticipatingServers(Collection<ParticipatingServer> participatingServers) {
        this.setParticipatingServers(participatingServers);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Job withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Job withStatus(JobStatus status) {
        this.status = status.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Job withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Job addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Job clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Job withType(String type) {
        this.setType(type);
        return this;
    }

    public Job withType(JobType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getCreationDateTime() != null) {
            sb.append("CreationDateTime: ").append(this.getCreationDateTime()).append(",");
        }
        if (this.getEndDateTime() != null) {
            sb.append("EndDateTime: ").append(this.getEndDateTime()).append(",");
        }
        if (this.getInitiatedBy() != null) {
            sb.append("InitiatedBy: ").append(this.getInitiatedBy()).append(",");
        }
        if (this.getJobID() != null) {
            sb.append("JobID: ").append(this.getJobID()).append(",");
        }
        if (this.getParticipatingServers() != null) {
            sb.append("ParticipatingServers: ").append(this.getParticipatingServers()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getCreationDateTime() == null ^ this.getCreationDateTime() == null) {
            return false;
        }
        if (other.getCreationDateTime() != null && !other.getCreationDateTime().equals(this.getCreationDateTime())) {
            return false;
        }
        if (other.getEndDateTime() == null ^ this.getEndDateTime() == null) {
            return false;
        }
        if (other.getEndDateTime() != null && !other.getEndDateTime().equals(this.getEndDateTime())) {
            return false;
        }
        if (other.getInitiatedBy() == null ^ this.getInitiatedBy() == null) {
            return false;
        }
        if (other.getInitiatedBy() != null && !other.getInitiatedBy().equals(this.getInitiatedBy())) {
            return false;
        }
        if (other.getJobID() == null ^ this.getJobID() == null) {
            return false;
        }
        if (other.getJobID() != null && !other.getJobID().equals(this.getJobID())) {
            return false;
        }
        if (other.getParticipatingServers() == null ^ this.getParticipatingServers() == null) {
            return false;
        }
        if (other.getParticipatingServers() != null && !other.getParticipatingServers().equals(this.getParticipatingServers())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDateTime() == null ? 0 : this.getCreationDateTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndDateTime() == null ? 0 : this.getEndDateTime().hashCode());
        hashCode = 31 * hashCode + (this.getInitiatedBy() == null ? 0 : this.getInitiatedBy().hashCode());
        hashCode = 31 * hashCode + (this.getJobID() == null ? 0 : this.getJobID().hashCode());
        hashCode = 31 * hashCode + (this.getParticipatingServers() == null ? 0 : this.getParticipatingServers().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public Job clone() {
        try {
            return (Job)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

