/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.memorydb.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.memorydb.model.Node;
import com.amazonaws.services.memorydb.model.transform.ShardMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Shard
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String status;
    private String slots;
    private List<Node> nodes;
    private Integer numberOfNodes;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Shard withName(String name) {
        this.setName(name);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Shard withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setSlots(String slots) {
        this.slots = slots;
    }

    public String getSlots() {
        return this.slots;
    }

    public Shard withSlots(String slots) {
        this.setSlots(slots);
        return this;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(Collection<Node> nodes) {
        if (nodes == null) {
            this.nodes = null;
            return;
        }
        this.nodes = new ArrayList<Node>(nodes);
    }

    public Shard withNodes(Node ... nodes) {
        if (this.nodes == null) {
            this.setNodes(new ArrayList<Node>(nodes.length));
        }
        for (Node ele : nodes) {
            this.nodes.add(ele);
        }
        return this;
    }

    public Shard withNodes(Collection<Node> nodes) {
        this.setNodes(nodes);
        return this;
    }

    public void setNumberOfNodes(Integer numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
    }

    public Integer getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public Shard withNumberOfNodes(Integer numberOfNodes) {
        this.setNumberOfNodes(numberOfNodes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getSlots() != null) {
            sb.append("Slots: ").append(this.getSlots()).append(",");
        }
        if (this.getNodes() != null) {
            sb.append("Nodes: ").append(this.getNodes()).append(",");
        }
        if (this.getNumberOfNodes() != null) {
            sb.append("NumberOfNodes: ").append(this.getNumberOfNodes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Shard)) {
            return false;
        }
        Shard other = (Shard)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getSlots() == null ^ this.getSlots() == null) {
            return false;
        }
        if (other.getSlots() != null && !other.getSlots().equals(this.getSlots())) {
            return false;
        }
        if (other.getNodes() == null ^ this.getNodes() == null) {
            return false;
        }
        if (other.getNodes() != null && !other.getNodes().equals(this.getNodes())) {
            return false;
        }
        if (other.getNumberOfNodes() == null ^ this.getNumberOfNodes() == null) {
            return false;
        }
        return other.getNumberOfNodes() == null || other.getNumberOfNodes().equals(this.getNumberOfNodes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSlots() == null ? 0 : this.getSlots().hashCode());
        hashCode = 31 * hashCode + (this.getNodes() == null ? 0 : this.getNodes().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfNodes() == null ? 0 : this.getNumberOfNodes().hashCode());
        return hashCode;
    }

    public Shard clone() {
        try {
            return (Shard)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShardMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

