/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.memorydb.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.memorydb.model.AuthenticationType;
import com.amazonaws.services.memorydb.model.transform.AuthenticationMarshaller;
import java.io.Serializable;

public class Authentication
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private Integer passwordCount;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Authentication withType(String type) {
        this.setType(type);
        return this;
    }

    public Authentication withType(AuthenticationType type) {
        this.type = type.toString();
        return this;
    }

    public void setPasswordCount(Integer passwordCount) {
        this.passwordCount = passwordCount;
    }

    public Integer getPasswordCount() {
        return this.passwordCount;
    }

    public Authentication withPasswordCount(Integer passwordCount) {
        this.setPasswordCount(passwordCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getPasswordCount() != null) {
            sb.append("PasswordCount: ").append(this.getPasswordCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Authentication)) {
            return false;
        }
        Authentication other = (Authentication)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getPasswordCount() == null ^ this.getPasswordCount() == null) {
            return false;
        }
        return other.getPasswordCount() == null || other.getPasswordCount().equals(this.getPasswordCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getPasswordCount() == null ? 0 : this.getPasswordCount().hashCode());
        return hashCode;
    }

    public Authentication clone() {
        try {
            return (Authentication)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuthenticationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

