/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediatailor.model.AlternateMedia;
import java.util.List;

@SdkInternalApi
public class AlternateMediaMarshaller {
    private static final MarshallingInfo<List> ADBREAKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdBreaks").build();
    private static final MarshallingInfo<StructuredPojo> CLIPRANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClipRange").build();
    private static final MarshallingInfo<Long> DURATIONMILLIS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DurationMillis").build();
    private static final MarshallingInfo<String> LIVESOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LiveSourceName").build();
    private static final MarshallingInfo<Long> SCHEDULEDSTARTTIMEMILLIS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScheduledStartTimeMillis").build();
    private static final MarshallingInfo<String> SOURCELOCATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceLocationName").build();
    private static final MarshallingInfo<String> VODSOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VodSourceName").build();
    private static final AlternateMediaMarshaller instance = new AlternateMediaMarshaller();

    public static AlternateMediaMarshaller getInstance() {
        return instance;
    }

    public void marshall(AlternateMedia alternateMedia, ProtocolMarshaller protocolMarshaller) {
        if (alternateMedia == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(alternateMedia.getAdBreaks(), ADBREAKS_BINDING);
            protocolMarshaller.marshall((Object)alternateMedia.getClipRange(), CLIPRANGE_BINDING);
            protocolMarshaller.marshall((Object)alternateMedia.getDurationMillis(), DURATIONMILLIS_BINDING);
            protocolMarshaller.marshall((Object)alternateMedia.getLiveSourceName(), LIVESOURCENAME_BINDING);
            protocolMarshaller.marshall((Object)alternateMedia.getScheduledStartTimeMillis(), SCHEDULEDSTARTTIMEMILLIS_BINDING);
            protocolMarshaller.marshall((Object)alternateMedia.getSourceLocationName(), SOURCELOCATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)alternateMedia.getVodSourceName(), VODSOURCENAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

