/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.medialive.model.Esam;

@SdkInternalApi
public class EsamMarshaller {
    private static final MarshallingInfo<String> ACQUISITIONPOINTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("acquisitionPointId").build();
    private static final MarshallingInfo<Integer> ADAVAILOFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adAvailOffset").build();
    private static final MarshallingInfo<String> PASSWORDPARAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("passwordParam").build();
    private static final MarshallingInfo<String> POISENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("poisEndpoint").build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("username").build();
    private static final MarshallingInfo<String> ZONEIDENTITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("zoneIdentity").build();
    private static final EsamMarshaller instance = new EsamMarshaller();

    public static EsamMarshaller getInstance() {
        return instance;
    }

    public void marshall(Esam esam, ProtocolMarshaller protocolMarshaller) {
        if (esam == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)esam.getAcquisitionPointId(), ACQUISITIONPOINTID_BINDING);
            protocolMarshaller.marshall((Object)esam.getAdAvailOffset(), ADAVAILOFFSET_BINDING);
            protocolMarshaller.marshall((Object)esam.getPasswordParam(), PASSWORDPARAM_BINDING);
            protocolMarshaller.marshall((Object)esam.getPoisEndpoint(), POISENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)esam.getUsername(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)esam.getZoneIdentity(), ZONEIDENTITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

