/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.MultiplexOutputDestination;
import com.amazonaws.services.medialive.model.MultiplexSettings;
import com.amazonaws.services.medialive.model.MultiplexState;
import com.amazonaws.services.medialive.model.transform.MultiplexMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Multiplex
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private List<String> availabilityZones;
    private List<MultiplexOutputDestination> destinations;
    private String id;
    private MultiplexSettings multiplexSettings;
    private String name;
    private Integer pipelinesRunningCount;
    private Integer programCount;
    private String state;
    private Map<String, String> tags;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Multiplex withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public List<String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new ArrayList<String>(availabilityZones);
    }

    public Multiplex withAvailabilityZones(String ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones(new ArrayList<String>(availabilityZones.length));
        }
        for (String ele : availabilityZones) {
            this.availabilityZones.add(ele);
        }
        return this;
    }

    public Multiplex withAvailabilityZones(Collection<String> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public List<MultiplexOutputDestination> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<MultiplexOutputDestination> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<MultiplexOutputDestination>(destinations);
    }

    public Multiplex withDestinations(MultiplexOutputDestination ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<MultiplexOutputDestination>(destinations.length));
        }
        for (MultiplexOutputDestination ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public Multiplex withDestinations(Collection<MultiplexOutputDestination> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Multiplex withId(String id) {
        this.setId(id);
        return this;
    }

    public void setMultiplexSettings(MultiplexSettings multiplexSettings) {
        this.multiplexSettings = multiplexSettings;
    }

    public MultiplexSettings getMultiplexSettings() {
        return this.multiplexSettings;
    }

    public Multiplex withMultiplexSettings(MultiplexSettings multiplexSettings) {
        this.setMultiplexSettings(multiplexSettings);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Multiplex withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPipelinesRunningCount(Integer pipelinesRunningCount) {
        this.pipelinesRunningCount = pipelinesRunningCount;
    }

    public Integer getPipelinesRunningCount() {
        return this.pipelinesRunningCount;
    }

    public Multiplex withPipelinesRunningCount(Integer pipelinesRunningCount) {
        this.setPipelinesRunningCount(pipelinesRunningCount);
        return this;
    }

    public void setProgramCount(Integer programCount) {
        this.programCount = programCount;
    }

    public Integer getProgramCount() {
        return this.programCount;
    }

    public Multiplex withProgramCount(Integer programCount) {
        this.setProgramCount(programCount);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Multiplex withState(String state) {
        this.setState(state);
        return this;
    }

    public Multiplex withState(MultiplexState state) {
        this.state = state.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Multiplex withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Multiplex addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Multiplex clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.getAvailabilityZones()).append(",");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getMultiplexSettings() != null) {
            sb.append("MultiplexSettings: ").append(this.getMultiplexSettings()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPipelinesRunningCount() != null) {
            sb.append("PipelinesRunningCount: ").append(this.getPipelinesRunningCount()).append(",");
        }
        if (this.getProgramCount() != null) {
            sb.append("ProgramCount: ").append(this.getProgramCount()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Multiplex)) {
            return false;
        }
        Multiplex other = (Multiplex)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getMultiplexSettings() == null ^ this.getMultiplexSettings() == null) {
            return false;
        }
        if (other.getMultiplexSettings() != null && !other.getMultiplexSettings().equals(this.getMultiplexSettings())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPipelinesRunningCount() == null ^ this.getPipelinesRunningCount() == null) {
            return false;
        }
        if (other.getPipelinesRunningCount() != null && !other.getPipelinesRunningCount().equals(this.getPipelinesRunningCount())) {
            return false;
        }
        if (other.getProgramCount() == null ^ this.getProgramCount() == null) {
            return false;
        }
        if (other.getProgramCount() != null && !other.getProgramCount().equals(this.getProgramCount())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getMultiplexSettings() == null ? 0 : this.getMultiplexSettings().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPipelinesRunningCount() == null ? 0 : this.getPipelinesRunningCount().hashCode());
        hashCode = 31 * hashCode + (this.getProgramCount() == null ? 0 : this.getProgramCount().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Multiplex clone() {
        try {
            return (Multiplex)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MultiplexMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

