/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.AutomatedAbrRule;
import com.amazonaws.services.mediaconvert.model.transform.AutomatedAbrSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AutomatedAbrSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer maxAbrBitrate;
    private Integer maxRenditions;
    private Integer minAbrBitrate;
    private List<AutomatedAbrRule> rules;

    public void setMaxAbrBitrate(Integer maxAbrBitrate) {
        this.maxAbrBitrate = maxAbrBitrate;
    }

    public Integer getMaxAbrBitrate() {
        return this.maxAbrBitrate;
    }

    public AutomatedAbrSettings withMaxAbrBitrate(Integer maxAbrBitrate) {
        this.setMaxAbrBitrate(maxAbrBitrate);
        return this;
    }

    public void setMaxRenditions(Integer maxRenditions) {
        this.maxRenditions = maxRenditions;
    }

    public Integer getMaxRenditions() {
        return this.maxRenditions;
    }

    public AutomatedAbrSettings withMaxRenditions(Integer maxRenditions) {
        this.setMaxRenditions(maxRenditions);
        return this;
    }

    public void setMinAbrBitrate(Integer minAbrBitrate) {
        this.minAbrBitrate = minAbrBitrate;
    }

    public Integer getMinAbrBitrate() {
        return this.minAbrBitrate;
    }

    public AutomatedAbrSettings withMinAbrBitrate(Integer minAbrBitrate) {
        this.setMinAbrBitrate(minAbrBitrate);
        return this;
    }

    public List<AutomatedAbrRule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<AutomatedAbrRule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<AutomatedAbrRule>(rules);
    }

    public AutomatedAbrSettings withRules(AutomatedAbrRule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<AutomatedAbrRule>(rules.length));
        }
        for (AutomatedAbrRule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public AutomatedAbrSettings withRules(Collection<AutomatedAbrRule> rules) {
        this.setRules(rules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMaxAbrBitrate() != null) {
            sb.append("MaxAbrBitrate: ").append(this.getMaxAbrBitrate()).append(",");
        }
        if (this.getMaxRenditions() != null) {
            sb.append("MaxRenditions: ").append(this.getMaxRenditions()).append(",");
        }
        if (this.getMinAbrBitrate() != null) {
            sb.append("MinAbrBitrate: ").append(this.getMinAbrBitrate()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedAbrSettings)) {
            return false;
        }
        AutomatedAbrSettings other = (AutomatedAbrSettings)obj;
        if (other.getMaxAbrBitrate() == null ^ this.getMaxAbrBitrate() == null) {
            return false;
        }
        if (other.getMaxAbrBitrate() != null && !other.getMaxAbrBitrate().equals(this.getMaxAbrBitrate())) {
            return false;
        }
        if (other.getMaxRenditions() == null ^ this.getMaxRenditions() == null) {
            return false;
        }
        if (other.getMaxRenditions() != null && !other.getMaxRenditions().equals(this.getMaxRenditions())) {
            return false;
        }
        if (other.getMinAbrBitrate() == null ^ this.getMinAbrBitrate() == null) {
            return false;
        }
        if (other.getMinAbrBitrate() != null && !other.getMinAbrBitrate().equals(this.getMinAbrBitrate())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        return other.getRules() == null || other.getRules().equals(this.getRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMaxAbrBitrate() == null ? 0 : this.getMaxAbrBitrate().hashCode());
        hashCode = 31 * hashCode + (this.getMaxRenditions() == null ? 0 : this.getMaxRenditions().hashCode());
        hashCode = 31 * hashCode + (this.getMinAbrBitrate() == null ? 0 : this.getMinAbrBitrate().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        return hashCode;
    }

    public AutomatedAbrSettings clone() {
        try {
            return (AutomatedAbrSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutomatedAbrSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

