/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.mediaconvert.AWSMediaConvertAsync;
import com.amazonaws.services.mediaconvert.AWSMediaConvertAsyncClientBuilder;
import com.amazonaws.services.mediaconvert.AWSMediaConvertClient;
import com.amazonaws.services.mediaconvert.model.AssociateCertificateRequest;
import com.amazonaws.services.mediaconvert.model.AssociateCertificateResult;
import com.amazonaws.services.mediaconvert.model.CancelJobRequest;
import com.amazonaws.services.mediaconvert.model.CancelJobResult;
import com.amazonaws.services.mediaconvert.model.CreateJobRequest;
import com.amazonaws.services.mediaconvert.model.CreateJobResult;
import com.amazonaws.services.mediaconvert.model.CreateJobTemplateRequest;
import com.amazonaws.services.mediaconvert.model.CreateJobTemplateResult;
import com.amazonaws.services.mediaconvert.model.CreatePresetRequest;
import com.amazonaws.services.mediaconvert.model.CreatePresetResult;
import com.amazonaws.services.mediaconvert.model.CreateQueueRequest;
import com.amazonaws.services.mediaconvert.model.CreateQueueResult;
import com.amazonaws.services.mediaconvert.model.DeleteJobTemplateRequest;
import com.amazonaws.services.mediaconvert.model.DeleteJobTemplateResult;
import com.amazonaws.services.mediaconvert.model.DeletePolicyRequest;
import com.amazonaws.services.mediaconvert.model.DeletePolicyResult;
import com.amazonaws.services.mediaconvert.model.DeletePresetRequest;
import com.amazonaws.services.mediaconvert.model.DeletePresetResult;
import com.amazonaws.services.mediaconvert.model.DeleteQueueRequest;
import com.amazonaws.services.mediaconvert.model.DeleteQueueResult;
import com.amazonaws.services.mediaconvert.model.DescribeEndpointsRequest;
import com.amazonaws.services.mediaconvert.model.DescribeEndpointsResult;
import com.amazonaws.services.mediaconvert.model.DisassociateCertificateRequest;
import com.amazonaws.services.mediaconvert.model.DisassociateCertificateResult;
import com.amazonaws.services.mediaconvert.model.GetJobRequest;
import com.amazonaws.services.mediaconvert.model.GetJobResult;
import com.amazonaws.services.mediaconvert.model.GetJobTemplateRequest;
import com.amazonaws.services.mediaconvert.model.GetJobTemplateResult;
import com.amazonaws.services.mediaconvert.model.GetPolicyRequest;
import com.amazonaws.services.mediaconvert.model.GetPolicyResult;
import com.amazonaws.services.mediaconvert.model.GetPresetRequest;
import com.amazonaws.services.mediaconvert.model.GetPresetResult;
import com.amazonaws.services.mediaconvert.model.GetQueueRequest;
import com.amazonaws.services.mediaconvert.model.GetQueueResult;
import com.amazonaws.services.mediaconvert.model.ListJobTemplatesRequest;
import com.amazonaws.services.mediaconvert.model.ListJobTemplatesResult;
import com.amazonaws.services.mediaconvert.model.ListJobsRequest;
import com.amazonaws.services.mediaconvert.model.ListJobsResult;
import com.amazonaws.services.mediaconvert.model.ListPresetsRequest;
import com.amazonaws.services.mediaconvert.model.ListPresetsResult;
import com.amazonaws.services.mediaconvert.model.ListQueuesRequest;
import com.amazonaws.services.mediaconvert.model.ListQueuesResult;
import com.amazonaws.services.mediaconvert.model.ListTagsForResourceRequest;
import com.amazonaws.services.mediaconvert.model.ListTagsForResourceResult;
import com.amazonaws.services.mediaconvert.model.PutPolicyRequest;
import com.amazonaws.services.mediaconvert.model.PutPolicyResult;
import com.amazonaws.services.mediaconvert.model.SearchJobsRequest;
import com.amazonaws.services.mediaconvert.model.SearchJobsResult;
import com.amazonaws.services.mediaconvert.model.TagResourceRequest;
import com.amazonaws.services.mediaconvert.model.TagResourceResult;
import com.amazonaws.services.mediaconvert.model.UntagResourceRequest;
import com.amazonaws.services.mediaconvert.model.UntagResourceResult;
import com.amazonaws.services.mediaconvert.model.UpdateJobTemplateRequest;
import com.amazonaws.services.mediaconvert.model.UpdateJobTemplateResult;
import com.amazonaws.services.mediaconvert.model.UpdatePresetRequest;
import com.amazonaws.services.mediaconvert.model.UpdatePresetResult;
import com.amazonaws.services.mediaconvert.model.UpdateQueueRequest;
import com.amazonaws.services.mediaconvert.model.UpdateQueueResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMediaConvertAsyncClient
extends AWSMediaConvertClient
implements AWSMediaConvertAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMediaConvertAsyncClientBuilder asyncBuilder() {
        return AWSMediaConvertAsyncClientBuilder.standard();
    }

    AWSMediaConvertAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSMediaConvertAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateCertificateResult> associateCertificateAsync(AssociateCertificateRequest request) {
        return this.associateCertificateAsync(request, null);
    }

    @Override
    public Future<AssociateCertificateResult> associateCertificateAsync(AssociateCertificateRequest request, final AsyncHandler<AssociateCertificateRequest, AssociateCertificateResult> asyncHandler) {
        final AssociateCertificateRequest finalRequest = (AssociateCertificateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateCertificateResult>(){

            @Override
            public AssociateCertificateResult call() throws Exception {
                AssociateCertificateResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeAssociateCertificate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(CancelJobRequest request) {
        return this.cancelJobAsync(request, null);
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(CancelJobRequest request, final AsyncHandler<CancelJobRequest, CancelJobResult> asyncHandler) {
        final CancelJobRequest finalRequest = (CancelJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelJobResult>(){

            @Override
            public CancelJobResult call() throws Exception {
                CancelJobResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeCancelJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateJobResult> createJobAsync(CreateJobRequest request) {
        return this.createJobAsync(request, null);
    }

    @Override
    public Future<CreateJobResult> createJobAsync(CreateJobRequest request, final AsyncHandler<CreateJobRequest, CreateJobResult> asyncHandler) {
        final CreateJobRequest finalRequest = (CreateJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateJobResult>(){

            @Override
            public CreateJobResult call() throws Exception {
                CreateJobResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeCreateJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateJobTemplateResult> createJobTemplateAsync(CreateJobTemplateRequest request) {
        return this.createJobTemplateAsync(request, null);
    }

    @Override
    public Future<CreateJobTemplateResult> createJobTemplateAsync(CreateJobTemplateRequest request, final AsyncHandler<CreateJobTemplateRequest, CreateJobTemplateResult> asyncHandler) {
        final CreateJobTemplateRequest finalRequest = (CreateJobTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateJobTemplateResult>(){

            @Override
            public CreateJobTemplateResult call() throws Exception {
                CreateJobTemplateResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeCreateJobTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePresetResult> createPresetAsync(CreatePresetRequest request) {
        return this.createPresetAsync(request, null);
    }

    @Override
    public Future<CreatePresetResult> createPresetAsync(CreatePresetRequest request, final AsyncHandler<CreatePresetRequest, CreatePresetResult> asyncHandler) {
        final CreatePresetRequest finalRequest = (CreatePresetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePresetResult>(){

            @Override
            public CreatePresetResult call() throws Exception {
                CreatePresetResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeCreatePreset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateQueueResult> createQueueAsync(CreateQueueRequest request) {
        return this.createQueueAsync(request, null);
    }

    @Override
    public Future<CreateQueueResult> createQueueAsync(CreateQueueRequest request, final AsyncHandler<CreateQueueRequest, CreateQueueResult> asyncHandler) {
        final CreateQueueRequest finalRequest = (CreateQueueRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateQueueResult>(){

            @Override
            public CreateQueueResult call() throws Exception {
                CreateQueueResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeCreateQueue(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteJobTemplateResult> deleteJobTemplateAsync(DeleteJobTemplateRequest request) {
        return this.deleteJobTemplateAsync(request, null);
    }

    @Override
    public Future<DeleteJobTemplateResult> deleteJobTemplateAsync(DeleteJobTemplateRequest request, final AsyncHandler<DeleteJobTemplateRequest, DeleteJobTemplateResult> asyncHandler) {
        final DeleteJobTemplateRequest finalRequest = (DeleteJobTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteJobTemplateResult>(){

            @Override
            public DeleteJobTemplateResult call() throws Exception {
                DeleteJobTemplateResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeDeleteJobTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePolicyResult> deletePolicyAsync(DeletePolicyRequest request) {
        return this.deletePolicyAsync(request, null);
    }

    @Override
    public Future<DeletePolicyResult> deletePolicyAsync(DeletePolicyRequest request, final AsyncHandler<DeletePolicyRequest, DeletePolicyResult> asyncHandler) {
        final DeletePolicyRequest finalRequest = (DeletePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePolicyResult>(){

            @Override
            public DeletePolicyResult call() throws Exception {
                DeletePolicyResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeDeletePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePresetResult> deletePresetAsync(DeletePresetRequest request) {
        return this.deletePresetAsync(request, null);
    }

    @Override
    public Future<DeletePresetResult> deletePresetAsync(DeletePresetRequest request, final AsyncHandler<DeletePresetRequest, DeletePresetResult> asyncHandler) {
        final DeletePresetRequest finalRequest = (DeletePresetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePresetResult>(){

            @Override
            public DeletePresetResult call() throws Exception {
                DeletePresetResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeDeletePreset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteQueueResult> deleteQueueAsync(DeleteQueueRequest request) {
        return this.deleteQueueAsync(request, null);
    }

    @Override
    public Future<DeleteQueueResult> deleteQueueAsync(DeleteQueueRequest request, final AsyncHandler<DeleteQueueRequest, DeleteQueueResult> asyncHandler) {
        final DeleteQueueRequest finalRequest = (DeleteQueueRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteQueueResult>(){

            @Override
            public DeleteQueueResult call() throws Exception {
                DeleteQueueResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeDeleteQueue(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<DescribeEndpointsResult> describeEndpointsAsync(DescribeEndpointsRequest request) {
        return this.describeEndpointsAsync(request, null);
    }

    @Override
    @Deprecated
    public Future<DescribeEndpointsResult> describeEndpointsAsync(DescribeEndpointsRequest request, final AsyncHandler<DescribeEndpointsRequest, DescribeEndpointsResult> asyncHandler) {
        final DescribeEndpointsRequest finalRequest = (DescribeEndpointsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEndpointsResult>(){

            @Override
            public DescribeEndpointsResult call() throws Exception {
                DescribeEndpointsResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeDescribeEndpoints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateCertificateResult> disassociateCertificateAsync(DisassociateCertificateRequest request) {
        return this.disassociateCertificateAsync(request, null);
    }

    @Override
    public Future<DisassociateCertificateResult> disassociateCertificateAsync(DisassociateCertificateRequest request, final AsyncHandler<DisassociateCertificateRequest, DisassociateCertificateResult> asyncHandler) {
        final DisassociateCertificateRequest finalRequest = (DisassociateCertificateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateCertificateResult>(){

            @Override
            public DisassociateCertificateResult call() throws Exception {
                DisassociateCertificateResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeDisassociateCertificate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetJobResult> getJobAsync(GetJobRequest request) {
        return this.getJobAsync(request, null);
    }

    @Override
    public Future<GetJobResult> getJobAsync(GetJobRequest request, final AsyncHandler<GetJobRequest, GetJobResult> asyncHandler) {
        final GetJobRequest finalRequest = (GetJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetJobResult>(){

            @Override
            public GetJobResult call() throws Exception {
                GetJobResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeGetJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetJobTemplateResult> getJobTemplateAsync(GetJobTemplateRequest request) {
        return this.getJobTemplateAsync(request, null);
    }

    @Override
    public Future<GetJobTemplateResult> getJobTemplateAsync(GetJobTemplateRequest request, final AsyncHandler<GetJobTemplateRequest, GetJobTemplateResult> asyncHandler) {
        final GetJobTemplateRequest finalRequest = (GetJobTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetJobTemplateResult>(){

            @Override
            public GetJobTemplateResult call() throws Exception {
                GetJobTemplateResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeGetJobTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPolicyResult> getPolicyAsync(GetPolicyRequest request) {
        return this.getPolicyAsync(request, null);
    }

    @Override
    public Future<GetPolicyResult> getPolicyAsync(GetPolicyRequest request, final AsyncHandler<GetPolicyRequest, GetPolicyResult> asyncHandler) {
        final GetPolicyRequest finalRequest = (GetPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPolicyResult>(){

            @Override
            public GetPolicyResult call() throws Exception {
                GetPolicyResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeGetPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPresetResult> getPresetAsync(GetPresetRequest request) {
        return this.getPresetAsync(request, null);
    }

    @Override
    public Future<GetPresetResult> getPresetAsync(GetPresetRequest request, final AsyncHandler<GetPresetRequest, GetPresetResult> asyncHandler) {
        final GetPresetRequest finalRequest = (GetPresetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPresetResult>(){

            @Override
            public GetPresetResult call() throws Exception {
                GetPresetResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeGetPreset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQueueResult> getQueueAsync(GetQueueRequest request) {
        return this.getQueueAsync(request, null);
    }

    @Override
    public Future<GetQueueResult> getQueueAsync(GetQueueRequest request, final AsyncHandler<GetQueueRequest, GetQueueResult> asyncHandler) {
        final GetQueueRequest finalRequest = (GetQueueRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQueueResult>(){

            @Override
            public GetQueueResult call() throws Exception {
                GetQueueResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeGetQueue(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobTemplatesResult> listJobTemplatesAsync(ListJobTemplatesRequest request) {
        return this.listJobTemplatesAsync(request, null);
    }

    @Override
    public Future<ListJobTemplatesResult> listJobTemplatesAsync(ListJobTemplatesRequest request, final AsyncHandler<ListJobTemplatesRequest, ListJobTemplatesResult> asyncHandler) {
        final ListJobTemplatesRequest finalRequest = (ListJobTemplatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListJobTemplatesResult>(){

            @Override
            public ListJobTemplatesResult call() throws Exception {
                ListJobTemplatesResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeListJobTemplates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request) {
        return this.listJobsAsync(request, null);
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request, final AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) {
        final ListJobsRequest finalRequest = (ListJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListJobsResult>(){

            @Override
            public ListJobsResult call() throws Exception {
                ListJobsResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeListJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPresetsResult> listPresetsAsync(ListPresetsRequest request) {
        return this.listPresetsAsync(request, null);
    }

    @Override
    public Future<ListPresetsResult> listPresetsAsync(ListPresetsRequest request, final AsyncHandler<ListPresetsRequest, ListPresetsResult> asyncHandler) {
        final ListPresetsRequest finalRequest = (ListPresetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPresetsResult>(){

            @Override
            public ListPresetsResult call() throws Exception {
                ListPresetsResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeListPresets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(ListQueuesRequest request) {
        return this.listQueuesAsync(request, null);
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(ListQueuesRequest request, final AsyncHandler<ListQueuesRequest, ListQueuesResult> asyncHandler) {
        final ListQueuesRequest finalRequest = (ListQueuesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListQueuesResult>(){

            @Override
            public ListQueuesResult call() throws Exception {
                ListQueuesResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeListQueues(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutPolicyResult> putPolicyAsync(PutPolicyRequest request) {
        return this.putPolicyAsync(request, null);
    }

    @Override
    public Future<PutPolicyResult> putPolicyAsync(PutPolicyRequest request, final AsyncHandler<PutPolicyRequest, PutPolicyResult> asyncHandler) {
        final PutPolicyRequest finalRequest = (PutPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutPolicyResult>(){

            @Override
            public PutPolicyResult call() throws Exception {
                PutPolicyResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executePutPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchJobsResult> searchJobsAsync(SearchJobsRequest request) {
        return this.searchJobsAsync(request, null);
    }

    @Override
    public Future<SearchJobsResult> searchJobsAsync(SearchJobsRequest request, final AsyncHandler<SearchJobsRequest, SearchJobsResult> asyncHandler) {
        final SearchJobsRequest finalRequest = (SearchJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchJobsResult>(){

            @Override
            public SearchJobsResult call() throws Exception {
                SearchJobsResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeSearchJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateJobTemplateResult> updateJobTemplateAsync(UpdateJobTemplateRequest request) {
        return this.updateJobTemplateAsync(request, null);
    }

    @Override
    public Future<UpdateJobTemplateResult> updateJobTemplateAsync(UpdateJobTemplateRequest request, final AsyncHandler<UpdateJobTemplateRequest, UpdateJobTemplateResult> asyncHandler) {
        final UpdateJobTemplateRequest finalRequest = (UpdateJobTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateJobTemplateResult>(){

            @Override
            public UpdateJobTemplateResult call() throws Exception {
                UpdateJobTemplateResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeUpdateJobTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePresetResult> updatePresetAsync(UpdatePresetRequest request) {
        return this.updatePresetAsync(request, null);
    }

    @Override
    public Future<UpdatePresetResult> updatePresetAsync(UpdatePresetRequest request, final AsyncHandler<UpdatePresetRequest, UpdatePresetResult> asyncHandler) {
        final UpdatePresetRequest finalRequest = (UpdatePresetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePresetResult>(){

            @Override
            public UpdatePresetResult call() throws Exception {
                UpdatePresetResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeUpdatePreset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateQueueResult> updateQueueAsync(UpdateQueueRequest request) {
        return this.updateQueueAsync(request, null);
    }

    @Override
    public Future<UpdateQueueResult> updateQueueAsync(UpdateQueueRequest request, final AsyncHandler<UpdateQueueRequest, UpdateQueueResult> asyncHandler) {
        final UpdateQueueRequest finalRequest = (UpdateQueueRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateQueueResult>(){

            @Override
            public UpdateQueueResult call() throws Exception {
                UpdateQueueResult result = null;
                try {
                    result = AWSMediaConvertAsyncClient.this.executeUpdateQueue(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

