/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.AutomatedEncodingSettings;
import com.amazonaws.services.mediaconvert.model.Output;
import com.amazonaws.services.mediaconvert.model.OutputGroupSettings;
import com.amazonaws.services.mediaconvert.model.transform.OutputGroupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OutputGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private AutomatedEncodingSettings automatedEncodingSettings;
    private String customName;
    private String name;
    private OutputGroupSettings outputGroupSettings;
    private List<Output> outputs;

    public void setAutomatedEncodingSettings(AutomatedEncodingSettings automatedEncodingSettings) {
        this.automatedEncodingSettings = automatedEncodingSettings;
    }

    public AutomatedEncodingSettings getAutomatedEncodingSettings() {
        return this.automatedEncodingSettings;
    }

    public OutputGroup withAutomatedEncodingSettings(AutomatedEncodingSettings automatedEncodingSettings) {
        this.setAutomatedEncodingSettings(automatedEncodingSettings);
        return this;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String getCustomName() {
        return this.customName;
    }

    public OutputGroup withCustomName(String customName) {
        this.setCustomName(customName);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public OutputGroup withName(String name) {
        this.setName(name);
        return this;
    }

    public void setOutputGroupSettings(OutputGroupSettings outputGroupSettings) {
        this.outputGroupSettings = outputGroupSettings;
    }

    public OutputGroupSettings getOutputGroupSettings() {
        return this.outputGroupSettings;
    }

    public OutputGroup withOutputGroupSettings(OutputGroupSettings outputGroupSettings) {
        this.setOutputGroupSettings(outputGroupSettings);
        return this;
    }

    public List<Output> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Collection<Output> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new ArrayList<Output>(outputs);
    }

    public OutputGroup withOutputs(Output ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new ArrayList<Output>(outputs.length));
        }
        for (Output ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public OutputGroup withOutputs(Collection<Output> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutomatedEncodingSettings() != null) {
            sb.append("AutomatedEncodingSettings: ").append(this.getAutomatedEncodingSettings()).append(",");
        }
        if (this.getCustomName() != null) {
            sb.append("CustomName: ").append(this.getCustomName()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOutputGroupSettings() != null) {
            sb.append("OutputGroupSettings: ").append(this.getOutputGroupSettings()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputGroup)) {
            return false;
        }
        OutputGroup other = (OutputGroup)obj;
        if (other.getAutomatedEncodingSettings() == null ^ this.getAutomatedEncodingSettings() == null) {
            return false;
        }
        if (other.getAutomatedEncodingSettings() != null && !other.getAutomatedEncodingSettings().equals(this.getAutomatedEncodingSettings())) {
            return false;
        }
        if (other.getCustomName() == null ^ this.getCustomName() == null) {
            return false;
        }
        if (other.getCustomName() != null && !other.getCustomName().equals(this.getCustomName())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOutputGroupSettings() == null ^ this.getOutputGroupSettings() == null) {
            return false;
        }
        if (other.getOutputGroupSettings() != null && !other.getOutputGroupSettings().equals(this.getOutputGroupSettings())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        return other.getOutputs() == null || other.getOutputs().equals(this.getOutputs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutomatedEncodingSettings() == null ? 0 : this.getAutomatedEncodingSettings().hashCode());
        hashCode = 31 * hashCode + (this.getCustomName() == null ? 0 : this.getCustomName().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOutputGroupSettings() == null ? 0 : this.getOutputGroupSettings().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        return hashCode;
    }

    public OutputGroup clone() {
        try {
            return (OutputGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

