/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.StaticKeyProvider;

@SdkInternalApi
public class StaticKeyProviderMarshaller {
    private static final MarshallingInfo<String> KEYFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyFormat").build();
    private static final MarshallingInfo<String> KEYFORMATVERSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyFormatVersions").build();
    private static final MarshallingInfo<String> STATICKEYVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("staticKeyValue").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").build();
    private static final StaticKeyProviderMarshaller instance = new StaticKeyProviderMarshaller();

    public static StaticKeyProviderMarshaller getInstance() {
        return instance;
    }

    public void marshall(StaticKeyProvider staticKeyProvider, ProtocolMarshaller protocolMarshaller) {
        if (staticKeyProvider == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)staticKeyProvider.getKeyFormat(), KEYFORMAT_BINDING);
            protocolMarshaller.marshall((Object)staticKeyProvider.getKeyFormatVersions(), KEYFORMATVERSIONS_BINDING);
            protocolMarshaller.marshall((Object)staticKeyProvider.getStaticKeyValue(), STATICKEYVALUE_BINDING);
            protocolMarshaller.marshall((Object)staticKeyProvider.getUrl(), URL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

