/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.MediaStreamSourceConfiguration;
import java.util.List;

@SdkInternalApi
public class MediaStreamSourceConfigurationMarshaller {
    private static final MarshallingInfo<String> ENCODINGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encodingName").build();
    private static final MarshallingInfo<List> INPUTCONFIGURATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputConfigurations").build();
    private static final MarshallingInfo<String> MEDIASTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mediaStreamName").build();
    private static final MediaStreamSourceConfigurationMarshaller instance = new MediaStreamSourceConfigurationMarshaller();

    public static MediaStreamSourceConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(MediaStreamSourceConfiguration mediaStreamSourceConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (mediaStreamSourceConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mediaStreamSourceConfiguration.getEncodingName(), ENCODINGNAME_BINDING);
            protocolMarshaller.marshall(mediaStreamSourceConfiguration.getInputConfigurations(), INPUTCONFIGURATIONS_BINDING);
            protocolMarshaller.marshall((Object)mediaStreamSourceConfiguration.getMediaStreamName(), MEDIASTREAMNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

