/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mailmanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mailmanager.model.Archive;
import java.util.Date;

@SdkInternalApi
public class ArchiveMarshaller {
    private static final MarshallingInfo<String> ARCHIVEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchiveId").build();
    private static final MarshallingInfo<String> ARCHIVENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchiveName").build();
    private static final MarshallingInfo<String> ARCHIVESTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchiveState").build();
    private static final MarshallingInfo<Date> LASTUPDATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedTimestamp").timestampFormat("unixTimestamp").build();
    private static final ArchiveMarshaller instance = new ArchiveMarshaller();

    public static ArchiveMarshaller getInstance() {
        return instance;
    }

    public void marshall(Archive archive, ProtocolMarshaller protocolMarshaller) {
        if (archive == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)archive.getArchiveId(), ARCHIVEID_BINDING);
            protocolMarshaller.marshall((Object)archive.getArchiveName(), ARCHIVENAME_BINDING);
            protocolMarshaller.marshall((Object)archive.getArchiveState(), ARCHIVESTATE_BINDING);
            protocolMarshaller.marshall((Object)archive.getLastUpdatedTimestamp(), LASTUPDATEDTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

