/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.macie2.model.S3WordsList;

@SdkInternalApi
public class S3WordsListMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketName").build();
    private static final MarshallingInfo<String> OBJECTKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("objectKey").build();
    private static final S3WordsListMarshaller instance = new S3WordsListMarshaller();

    public static S3WordsListMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3WordsList s3WordsList, ProtocolMarshaller protocolMarshaller) {
        if (s3WordsList == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3WordsList.getBucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3WordsList.getObjectKey(), OBJECTKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

