/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.macie.model.S3ResourceClassification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListS3ResourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<S3ResourceClassification> s3Resources;
    private String nextToken;

    public List<S3ResourceClassification> getS3Resources() {
        return this.s3Resources;
    }

    public void setS3Resources(Collection<S3ResourceClassification> s3Resources) {
        if (s3Resources == null) {
            this.s3Resources = null;
            return;
        }
        this.s3Resources = new ArrayList<S3ResourceClassification>(s3Resources);
    }

    public ListS3ResourcesResult withS3Resources(S3ResourceClassification ... s3Resources) {
        if (this.s3Resources == null) {
            this.setS3Resources(new ArrayList<S3ResourceClassification>(s3Resources.length));
        }
        for (S3ResourceClassification ele : s3Resources) {
            this.s3Resources.add(ele);
        }
        return this;
    }

    public ListS3ResourcesResult withS3Resources(Collection<S3ResourceClassification> s3Resources) {
        this.setS3Resources(s3Resources);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListS3ResourcesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3Resources() != null) {
            sb.append("S3Resources: ").append(this.getS3Resources()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListS3ResourcesResult)) {
            return false;
        }
        ListS3ResourcesResult other = (ListS3ResourcesResult)obj;
        if (other.getS3Resources() == null ^ this.getS3Resources() == null) {
            return false;
        }
        if (other.getS3Resources() != null && !other.getS3Resources().equals(this.getS3Resources())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Resources() == null ? 0 : this.getS3Resources().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListS3ResourcesResult clone() {
        try {
            return (ListS3ResourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

