/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.machinelearning.model.RDSDataSpec;
import java.util.List;

@SdkInternalApi
public class RDSDataSpecMarshaller {
    private static final MarshallingInfo<StructuredPojo> DATABASEINFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseInformation").build();
    private static final MarshallingInfo<String> SELECTSQLQUERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SelectSqlQuery").build();
    private static final MarshallingInfo<StructuredPojo> DATABASECREDENTIALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseCredentials").build();
    private static final MarshallingInfo<String> S3STAGINGLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3StagingLocation").build();
    private static final MarshallingInfo<String> DATAREARRANGEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataRearrangement").build();
    private static final MarshallingInfo<String> DATASCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSchema").build();
    private static final MarshallingInfo<String> DATASCHEMAURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSchemaUri").build();
    private static final MarshallingInfo<String> RESOURCEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceRole").build();
    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRole").build();
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").build();
    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIds").build();
    private static final RDSDataSpecMarshaller instance = new RDSDataSpecMarshaller();

    public static RDSDataSpecMarshaller getInstance() {
        return instance;
    }

    public void marshall(RDSDataSpec rDSDataSpec, ProtocolMarshaller protocolMarshaller) {
        if (rDSDataSpec == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)rDSDataSpec.getDatabaseInformation(), DATABASEINFORMATION_BINDING);
            protocolMarshaller.marshall((Object)rDSDataSpec.getSelectSqlQuery(), SELECTSQLQUERY_BINDING);
            protocolMarshaller.marshall((Object)rDSDataSpec.getDatabaseCredentials(), DATABASECREDENTIALS_BINDING);
            protocolMarshaller.marshall((Object)rDSDataSpec.getS3StagingLocation(), S3STAGINGLOCATION_BINDING);
            protocolMarshaller.marshall((Object)rDSDataSpec.getDataRearrangement(), DATAREARRANGEMENT_BINDING);
            protocolMarshaller.marshall((Object)rDSDataSpec.getDataSchema(), DATASCHEMA_BINDING);
            protocolMarshaller.marshall((Object)rDSDataSpec.getDataSchemaUri(), DATASCHEMAURI_BINDING);
            protocolMarshaller.marshall((Object)rDSDataSpec.getResourceRole(), RESOURCEROLE_BINDING);
            protocolMarshaller.marshall((Object)rDSDataSpec.getServiceRole(), SERVICEROLE_BINDING);
            protocolMarshaller.marshall((Object)rDSDataSpec.getSubnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall(rDSDataSpec.getSecurityGroupIds(), SECURITYGROUPIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

