/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.location;

import javax.annotation.Generated;

import com.amazonaws.services.location.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonLocation}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonLocation implements AmazonLocation {

    protected AbstractAmazonLocation() {
    }

    @Override
    public AssociateTrackerConsumerResult associateTrackerConsumer(AssociateTrackerConsumerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDeleteDevicePositionHistoryResult batchDeleteDevicePositionHistory(BatchDeleteDevicePositionHistoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDeleteGeofenceResult batchDeleteGeofence(BatchDeleteGeofenceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchEvaluateGeofencesResult batchEvaluateGeofences(BatchEvaluateGeofencesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetDevicePositionResult batchGetDevicePosition(BatchGetDevicePositionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchPutGeofenceResult batchPutGeofence(BatchPutGeofenceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUpdateDevicePositionResult batchUpdateDevicePosition(BatchUpdateDevicePositionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CalculateRouteResult calculateRoute(CalculateRouteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGeofenceCollectionResult createGeofenceCollection(CreateGeofenceCollectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMapResult createMap(CreateMapRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePlaceIndexResult createPlaceIndex(CreatePlaceIndexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRouteCalculatorResult createRouteCalculator(CreateRouteCalculatorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTrackerResult createTracker(CreateTrackerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGeofenceCollectionResult deleteGeofenceCollection(DeleteGeofenceCollectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMapResult deleteMap(DeleteMapRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePlaceIndexResult deletePlaceIndex(DeletePlaceIndexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRouteCalculatorResult deleteRouteCalculator(DeleteRouteCalculatorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTrackerResult deleteTracker(DeleteTrackerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGeofenceCollectionResult describeGeofenceCollection(DescribeGeofenceCollectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMapResult describeMap(DescribeMapRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePlaceIndexResult describePlaceIndex(DescribePlaceIndexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRouteCalculatorResult describeRouteCalculator(DescribeRouteCalculatorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTrackerResult describeTracker(DescribeTrackerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateTrackerConsumerResult disassociateTrackerConsumer(DisassociateTrackerConsumerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDevicePositionResult getDevicePosition(GetDevicePositionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDevicePositionHistoryResult getDevicePositionHistory(GetDevicePositionHistoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGeofenceResult getGeofence(GetGeofenceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMapGlyphsResult getMapGlyphs(GetMapGlyphsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMapSpritesResult getMapSprites(GetMapSpritesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMapStyleDescriptorResult getMapStyleDescriptor(GetMapStyleDescriptorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMapTileResult getMapTile(GetMapTileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDevicePositionsResult listDevicePositions(ListDevicePositionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGeofenceCollectionsResult listGeofenceCollections(ListGeofenceCollectionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGeofencesResult listGeofences(ListGeofencesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMapsResult listMaps(ListMapsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPlaceIndexesResult listPlaceIndexes(ListPlaceIndexesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRouteCalculatorsResult listRouteCalculators(ListRouteCalculatorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrackerConsumersResult listTrackerConsumers(ListTrackerConsumersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrackersResult listTrackers(ListTrackersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutGeofenceResult putGeofence(PutGeofenceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchPlaceIndexForPositionResult searchPlaceIndexForPosition(SearchPlaceIndexForPositionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchPlaceIndexForTextResult searchPlaceIndexForText(SearchPlaceIndexForTextRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGeofenceCollectionResult updateGeofenceCollection(UpdateGeofenceCollectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMapResult updateMap(UpdateMapRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePlaceIndexResult updatePlaceIndex(UpdatePlaceIndexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRouteCalculatorResult updateRouteCalculator(UpdateRouteCalculatorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTrackerResult updateTracker(UpdateTrackerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
