/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.location.model.CellSignals;
import com.amazonaws.services.location.model.PositionalAccuracy;
import com.amazonaws.services.location.model.WiFiAccessPoint;
import com.amazonaws.services.location.model.transform.DeviceStateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DeviceState
implements Serializable,
Cloneable,
StructuredPojo {
    private String deviceId;
    private Date sampleTime;
    private List<Double> position;
    private PositionalAccuracy accuracy;
    private String ipv4Address;
    private List<WiFiAccessPoint> wiFiAccessPoints;
    private CellSignals cellSignals;

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public DeviceState withDeviceId(String deviceId) {
        this.setDeviceId(deviceId);
        return this;
    }

    public void setSampleTime(Date sampleTime) {
        this.sampleTime = sampleTime;
    }

    public Date getSampleTime() {
        return this.sampleTime;
    }

    public DeviceState withSampleTime(Date sampleTime) {
        this.setSampleTime(sampleTime);
        return this;
    }

    public List<Double> getPosition() {
        return this.position;
    }

    public void setPosition(Collection<Double> position) {
        if (position == null) {
            this.position = null;
            return;
        }
        this.position = new ArrayList<Double>(position);
    }

    public DeviceState withPosition(Double ... position) {
        if (this.position == null) {
            this.setPosition(new ArrayList<Double>(position.length));
        }
        for (Double ele : position) {
            this.position.add(ele);
        }
        return this;
    }

    public DeviceState withPosition(Collection<Double> position) {
        this.setPosition(position);
        return this;
    }

    public void setAccuracy(PositionalAccuracy accuracy) {
        this.accuracy = accuracy;
    }

    public PositionalAccuracy getAccuracy() {
        return this.accuracy;
    }

    public DeviceState withAccuracy(PositionalAccuracy accuracy) {
        this.setAccuracy(accuracy);
        return this;
    }

    public void setIpv4Address(String ipv4Address) {
        this.ipv4Address = ipv4Address;
    }

    public String getIpv4Address() {
        return this.ipv4Address;
    }

    public DeviceState withIpv4Address(String ipv4Address) {
        this.setIpv4Address(ipv4Address);
        return this;
    }

    public List<WiFiAccessPoint> getWiFiAccessPoints() {
        return this.wiFiAccessPoints;
    }

    public void setWiFiAccessPoints(Collection<WiFiAccessPoint> wiFiAccessPoints) {
        if (wiFiAccessPoints == null) {
            this.wiFiAccessPoints = null;
            return;
        }
        this.wiFiAccessPoints = new ArrayList<WiFiAccessPoint>(wiFiAccessPoints);
    }

    public DeviceState withWiFiAccessPoints(WiFiAccessPoint ... wiFiAccessPoints) {
        if (this.wiFiAccessPoints == null) {
            this.setWiFiAccessPoints(new ArrayList<WiFiAccessPoint>(wiFiAccessPoints.length));
        }
        for (WiFiAccessPoint ele : wiFiAccessPoints) {
            this.wiFiAccessPoints.add(ele);
        }
        return this;
    }

    public DeviceState withWiFiAccessPoints(Collection<WiFiAccessPoint> wiFiAccessPoints) {
        this.setWiFiAccessPoints(wiFiAccessPoints);
        return this;
    }

    public void setCellSignals(CellSignals cellSignals) {
        this.cellSignals = cellSignals;
    }

    public CellSignals getCellSignals() {
        return this.cellSignals;
    }

    public DeviceState withCellSignals(CellSignals cellSignals) {
        this.setCellSignals(cellSignals);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeviceId() != null) {
            sb.append("DeviceId: ").append(this.getDeviceId()).append(",");
        }
        if (this.getSampleTime() != null) {
            sb.append("SampleTime: ").append(this.getSampleTime()).append(",");
        }
        if (this.getPosition() != null) {
            sb.append("Position: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getAccuracy() != null) {
            sb.append("Accuracy: ").append(this.getAccuracy()).append(",");
        }
        if (this.getIpv4Address() != null) {
            sb.append("Ipv4Address: ").append(this.getIpv4Address()).append(",");
        }
        if (this.getWiFiAccessPoints() != null) {
            sb.append("WiFiAccessPoints: ").append(this.getWiFiAccessPoints()).append(",");
        }
        if (this.getCellSignals() != null) {
            sb.append("CellSignals: ").append(this.getCellSignals());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceState)) {
            return false;
        }
        DeviceState other = (DeviceState)obj;
        if (other.getDeviceId() == null ^ this.getDeviceId() == null) {
            return false;
        }
        if (other.getDeviceId() != null && !other.getDeviceId().equals(this.getDeviceId())) {
            return false;
        }
        if (other.getSampleTime() == null ^ this.getSampleTime() == null) {
            return false;
        }
        if (other.getSampleTime() != null && !other.getSampleTime().equals(this.getSampleTime())) {
            return false;
        }
        if (other.getPosition() == null ^ this.getPosition() == null) {
            return false;
        }
        if (other.getPosition() != null && !other.getPosition().equals(this.getPosition())) {
            return false;
        }
        if (other.getAccuracy() == null ^ this.getAccuracy() == null) {
            return false;
        }
        if (other.getAccuracy() != null && !other.getAccuracy().equals(this.getAccuracy())) {
            return false;
        }
        if (other.getIpv4Address() == null ^ this.getIpv4Address() == null) {
            return false;
        }
        if (other.getIpv4Address() != null && !other.getIpv4Address().equals(this.getIpv4Address())) {
            return false;
        }
        if (other.getWiFiAccessPoints() == null ^ this.getWiFiAccessPoints() == null) {
            return false;
        }
        if (other.getWiFiAccessPoints() != null && !other.getWiFiAccessPoints().equals(this.getWiFiAccessPoints())) {
            return false;
        }
        if (other.getCellSignals() == null ^ this.getCellSignals() == null) {
            return false;
        }
        return other.getCellSignals() == null || other.getCellSignals().equals(this.getCellSignals());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeviceId() == null ? 0 : this.getDeviceId().hashCode());
        hashCode = 31 * hashCode + (this.getSampleTime() == null ? 0 : this.getSampleTime().hashCode());
        hashCode = 31 * hashCode + (this.getPosition() == null ? 0 : this.getPosition().hashCode());
        hashCode = 31 * hashCode + (this.getAccuracy() == null ? 0 : this.getAccuracy().hashCode());
        hashCode = 31 * hashCode + (this.getIpv4Address() == null ? 0 : this.getIpv4Address().hashCode());
        hashCode = 31 * hashCode + (this.getWiFiAccessPoints() == null ? 0 : this.getWiFiAccessPoints().hashCode());
        hashCode = 31 * hashCode + (this.getCellSignals() == null ? 0 : this.getCellSignals().hashCode());
        return hashCode;
    }

    public DeviceState clone() {
        try {
            return (DeviceState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

