/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lightsail.model.ContactProtocol;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetContactMethodsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> protocols;

    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(Collection<String> protocols) {
        if (protocols == null) {
            this.protocols = null;
            return;
        }
        this.protocols = new ArrayList<String>(protocols);
    }

    public GetContactMethodsRequest withProtocols(String ... protocols) {
        if (this.protocols == null) {
            this.setProtocols(new ArrayList<String>(protocols.length));
        }
        for (String ele : protocols) {
            this.protocols.add(ele);
        }
        return this;
    }

    public GetContactMethodsRequest withProtocols(Collection<String> protocols) {
        this.setProtocols(protocols);
        return this;
    }

    public GetContactMethodsRequest withProtocols(ContactProtocol ... protocols) {
        ArrayList<String> protocolsCopy = new ArrayList<String>(protocols.length);
        for (ContactProtocol value : protocols) {
            protocolsCopy.add(value.toString());
        }
        if (this.getProtocols() == null) {
            this.setProtocols(protocolsCopy);
        } else {
            this.getProtocols().addAll(protocolsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProtocols() != null) {
            sb.append("Protocols: ").append(this.getProtocols());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContactMethodsRequest)) {
            return false;
        }
        GetContactMethodsRequest other = (GetContactMethodsRequest)obj;
        if (other.getProtocols() == null ^ this.getProtocols() == null) {
            return false;
        }
        return other.getProtocols() == null || other.getProtocols().equals(this.getProtocols());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProtocols() == null ? 0 : this.getProtocols().hashCode());
        return hashCode;
    }

    public GetContactMethodsRequest clone() {
        return (GetContactMethodsRequest)super.clone();
    }
}

