/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.DiskSnapshotState;
import com.amazonaws.services.lightsail.model.ResourceLocation;
import com.amazonaws.services.lightsail.model.ResourceType;
import com.amazonaws.services.lightsail.model.Tag;
import com.amazonaws.services.lightsail.model.transform.DiskSnapshotMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DiskSnapshot
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String arn;
    private String supportCode;
    private Date createdAt;
    private ResourceLocation location;
    private String resourceType;
    private List<Tag> tags;
    private Integer sizeInGb;
    private String state;
    private String progress;
    private String fromDiskName;
    private String fromDiskArn;
    private String fromInstanceName;
    private String fromInstanceArn;
    private Boolean isFromAutoSnapshot;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DiskSnapshot withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public DiskSnapshot withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setSupportCode(String supportCode) {
        this.supportCode = supportCode;
    }

    public String getSupportCode() {
        return this.supportCode;
    }

    public DiskSnapshot withSupportCode(String supportCode) {
        this.setSupportCode(supportCode);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public DiskSnapshot withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setLocation(ResourceLocation location) {
        this.location = location;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public DiskSnapshot withLocation(ResourceLocation location) {
        this.setLocation(location);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public DiskSnapshot withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public DiskSnapshot withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public DiskSnapshot withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public DiskSnapshot withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setSizeInGb(Integer sizeInGb) {
        this.sizeInGb = sizeInGb;
    }

    public Integer getSizeInGb() {
        return this.sizeInGb;
    }

    public DiskSnapshot withSizeInGb(Integer sizeInGb) {
        this.setSizeInGb(sizeInGb);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public DiskSnapshot withState(String state) {
        this.setState(state);
        return this;
    }

    public DiskSnapshot withState(DiskSnapshotState state) {
        this.state = state.toString();
        return this;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    public String getProgress() {
        return this.progress;
    }

    public DiskSnapshot withProgress(String progress) {
        this.setProgress(progress);
        return this;
    }

    public void setFromDiskName(String fromDiskName) {
        this.fromDiskName = fromDiskName;
    }

    public String getFromDiskName() {
        return this.fromDiskName;
    }

    public DiskSnapshot withFromDiskName(String fromDiskName) {
        this.setFromDiskName(fromDiskName);
        return this;
    }

    public void setFromDiskArn(String fromDiskArn) {
        this.fromDiskArn = fromDiskArn;
    }

    public String getFromDiskArn() {
        return this.fromDiskArn;
    }

    public DiskSnapshot withFromDiskArn(String fromDiskArn) {
        this.setFromDiskArn(fromDiskArn);
        return this;
    }

    public void setFromInstanceName(String fromInstanceName) {
        this.fromInstanceName = fromInstanceName;
    }

    public String getFromInstanceName() {
        return this.fromInstanceName;
    }

    public DiskSnapshot withFromInstanceName(String fromInstanceName) {
        this.setFromInstanceName(fromInstanceName);
        return this;
    }

    public void setFromInstanceArn(String fromInstanceArn) {
        this.fromInstanceArn = fromInstanceArn;
    }

    public String getFromInstanceArn() {
        return this.fromInstanceArn;
    }

    public DiskSnapshot withFromInstanceArn(String fromInstanceArn) {
        this.setFromInstanceArn(fromInstanceArn);
        return this;
    }

    public void setIsFromAutoSnapshot(Boolean isFromAutoSnapshot) {
        this.isFromAutoSnapshot = isFromAutoSnapshot;
    }

    public Boolean getIsFromAutoSnapshot() {
        return this.isFromAutoSnapshot;
    }

    public DiskSnapshot withIsFromAutoSnapshot(Boolean isFromAutoSnapshot) {
        this.setIsFromAutoSnapshot(isFromAutoSnapshot);
        return this;
    }

    public Boolean isFromAutoSnapshot() {
        return this.isFromAutoSnapshot;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getSupportCode() != null) {
            sb.append("SupportCode: ").append(this.getSupportCode()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getSizeInGb() != null) {
            sb.append("SizeInGb: ").append(this.getSizeInGb()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getProgress() != null) {
            sb.append("Progress: ").append(this.getProgress()).append(",");
        }
        if (this.getFromDiskName() != null) {
            sb.append("FromDiskName: ").append(this.getFromDiskName()).append(",");
        }
        if (this.getFromDiskArn() != null) {
            sb.append("FromDiskArn: ").append(this.getFromDiskArn()).append(",");
        }
        if (this.getFromInstanceName() != null) {
            sb.append("FromInstanceName: ").append(this.getFromInstanceName()).append(",");
        }
        if (this.getFromInstanceArn() != null) {
            sb.append("FromInstanceArn: ").append(this.getFromInstanceArn()).append(",");
        }
        if (this.getIsFromAutoSnapshot() != null) {
            sb.append("IsFromAutoSnapshot: ").append(this.getIsFromAutoSnapshot());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskSnapshot)) {
            return false;
        }
        DiskSnapshot other = (DiskSnapshot)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getSupportCode() == null ^ this.getSupportCode() == null) {
            return false;
        }
        if (other.getSupportCode() != null && !other.getSupportCode().equals(this.getSupportCode())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getSizeInGb() == null ^ this.getSizeInGb() == null) {
            return false;
        }
        if (other.getSizeInGb() != null && !other.getSizeInGb().equals(this.getSizeInGb())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getProgress() == null ^ this.getProgress() == null) {
            return false;
        }
        if (other.getProgress() != null && !other.getProgress().equals(this.getProgress())) {
            return false;
        }
        if (other.getFromDiskName() == null ^ this.getFromDiskName() == null) {
            return false;
        }
        if (other.getFromDiskName() != null && !other.getFromDiskName().equals(this.getFromDiskName())) {
            return false;
        }
        if (other.getFromDiskArn() == null ^ this.getFromDiskArn() == null) {
            return false;
        }
        if (other.getFromDiskArn() != null && !other.getFromDiskArn().equals(this.getFromDiskArn())) {
            return false;
        }
        if (other.getFromInstanceName() == null ^ this.getFromInstanceName() == null) {
            return false;
        }
        if (other.getFromInstanceName() != null && !other.getFromInstanceName().equals(this.getFromInstanceName())) {
            return false;
        }
        if (other.getFromInstanceArn() == null ^ this.getFromInstanceArn() == null) {
            return false;
        }
        if (other.getFromInstanceArn() != null && !other.getFromInstanceArn().equals(this.getFromInstanceArn())) {
            return false;
        }
        if (other.getIsFromAutoSnapshot() == null ^ this.getIsFromAutoSnapshot() == null) {
            return false;
        }
        return other.getIsFromAutoSnapshot() == null || other.getIsFromAutoSnapshot().equals(this.getIsFromAutoSnapshot());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getSupportCode() == null ? 0 : this.getSupportCode().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getSizeInGb() == null ? 0 : this.getSizeInGb().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getProgress() == null ? 0 : this.getProgress().hashCode());
        hashCode = 31 * hashCode + (this.getFromDiskName() == null ? 0 : this.getFromDiskName().hashCode());
        hashCode = 31 * hashCode + (this.getFromDiskArn() == null ? 0 : this.getFromDiskArn().hashCode());
        hashCode = 31 * hashCode + (this.getFromInstanceName() == null ? 0 : this.getFromInstanceName().hashCode());
        hashCode = 31 * hashCode + (this.getFromInstanceArn() == null ? 0 : this.getFromInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getIsFromAutoSnapshot() == null ? 0 : this.getIsFromAutoSnapshot().hashCode());
        return hashCode;
    }

    public DiskSnapshot clone() {
        try {
            return (DiskSnapshot)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DiskSnapshotMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

