/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.Container;
import com.amazonaws.services.lightsail.model.ContainerServiceDeploymentState;
import com.amazonaws.services.lightsail.model.ContainerServiceEndpoint;
import com.amazonaws.services.lightsail.model.transform.ContainerServiceDeploymentMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ContainerServiceDeployment
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer version;
    private String state;
    private Map<String, Container> containers;
    private ContainerServiceEndpoint publicEndpoint;
    private Date createdAt;

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    public ContainerServiceDeployment withVersion(Integer version) {
        this.setVersion(version);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public ContainerServiceDeployment withState(String state) {
        this.setState(state);
        return this;
    }

    public ContainerServiceDeployment withState(ContainerServiceDeploymentState state) {
        this.state = state.toString();
        return this;
    }

    public Map<String, Container> getContainers() {
        return this.containers;
    }

    public void setContainers(Map<String, Container> containers) {
        this.containers = containers;
    }

    public ContainerServiceDeployment withContainers(Map<String, Container> containers) {
        this.setContainers(containers);
        return this;
    }

    public ContainerServiceDeployment addContainersEntry(String key, Container value) {
        if (null == this.containers) {
            this.containers = new HashMap<String, Container>();
        }
        if (this.containers.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.containers.put(key, value);
        return this;
    }

    public ContainerServiceDeployment clearContainersEntries() {
        this.containers = null;
        return this;
    }

    public void setPublicEndpoint(ContainerServiceEndpoint publicEndpoint) {
        this.publicEndpoint = publicEndpoint;
    }

    public ContainerServiceEndpoint getPublicEndpoint() {
        return this.publicEndpoint;
    }

    public ContainerServiceDeployment withPublicEndpoint(ContainerServiceEndpoint publicEndpoint) {
        this.setPublicEndpoint(publicEndpoint);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public ContainerServiceDeployment withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getContainers() != null) {
            sb.append("Containers: ").append(this.getContainers()).append(",");
        }
        if (this.getPublicEndpoint() != null) {
            sb.append("PublicEndpoint: ").append(this.getPublicEndpoint()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerServiceDeployment)) {
            return false;
        }
        ContainerServiceDeployment other = (ContainerServiceDeployment)obj;
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getContainers() == null ^ this.getContainers() == null) {
            return false;
        }
        if (other.getContainers() != null && !other.getContainers().equals(this.getContainers())) {
            return false;
        }
        if (other.getPublicEndpoint() == null ^ this.getPublicEndpoint() == null) {
            return false;
        }
        if (other.getPublicEndpoint() != null && !other.getPublicEndpoint().equals(this.getPublicEndpoint())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        return other.getCreatedAt() == null || other.getCreatedAt().equals(this.getCreatedAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getContainers() == null ? 0 : this.getContainers().hashCode());
        hashCode = 31 * hashCode + (this.getPublicEndpoint() == null ? 0 : this.getPublicEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        return hashCode;
    }

    public ContainerServiceDeployment clone() {
        try {
            return (ContainerServiceDeployment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerServiceDeploymentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

