/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.AlarmState;
import com.amazonaws.services.lightsail.model.ComparisonOperator;
import com.amazonaws.services.lightsail.model.ContactProtocol;
import com.amazonaws.services.lightsail.model.MetricName;
import com.amazonaws.services.lightsail.model.MetricStatistic;
import com.amazonaws.services.lightsail.model.MetricUnit;
import com.amazonaws.services.lightsail.model.MonitoredResourceInfo;
import com.amazonaws.services.lightsail.model.ResourceLocation;
import com.amazonaws.services.lightsail.model.ResourceType;
import com.amazonaws.services.lightsail.model.TreatMissingData;
import com.amazonaws.services.lightsail.model.transform.AlarmMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Alarm
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String arn;
    private Date createdAt;
    private ResourceLocation location;
    private String resourceType;
    private String supportCode;
    private MonitoredResourceInfo monitoredResourceInfo;
    private String comparisonOperator;
    private Integer evaluationPeriods;
    private Integer period;
    private Double threshold;
    private Integer datapointsToAlarm;
    private String treatMissingData;
    private String statistic;
    private String metricName;
    private String state;
    private String unit;
    private List<String> contactProtocols;
    private List<String> notificationTriggers;
    private Boolean notificationEnabled;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Alarm withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Alarm withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Alarm withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setLocation(ResourceLocation location) {
        this.location = location;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public Alarm withLocation(ResourceLocation location) {
        this.setLocation(location);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public Alarm withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public Alarm withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public void setSupportCode(String supportCode) {
        this.supportCode = supportCode;
    }

    public String getSupportCode() {
        return this.supportCode;
    }

    public Alarm withSupportCode(String supportCode) {
        this.setSupportCode(supportCode);
        return this;
    }

    public void setMonitoredResourceInfo(MonitoredResourceInfo monitoredResourceInfo) {
        this.monitoredResourceInfo = monitoredResourceInfo;
    }

    public MonitoredResourceInfo getMonitoredResourceInfo() {
        return this.monitoredResourceInfo;
    }

    public Alarm withMonitoredResourceInfo(MonitoredResourceInfo monitoredResourceInfo) {
        this.setMonitoredResourceInfo(monitoredResourceInfo);
        return this;
    }

    public void setComparisonOperator(String comparisonOperator) {
        this.comparisonOperator = comparisonOperator;
    }

    public String getComparisonOperator() {
        return this.comparisonOperator;
    }

    public Alarm withComparisonOperator(String comparisonOperator) {
        this.setComparisonOperator(comparisonOperator);
        return this;
    }

    public Alarm withComparisonOperator(ComparisonOperator comparisonOperator) {
        this.comparisonOperator = comparisonOperator.toString();
        return this;
    }

    public void setEvaluationPeriods(Integer evaluationPeriods) {
        this.evaluationPeriods = evaluationPeriods;
    }

    public Integer getEvaluationPeriods() {
        return this.evaluationPeriods;
    }

    public Alarm withEvaluationPeriods(Integer evaluationPeriods) {
        this.setEvaluationPeriods(evaluationPeriods);
        return this;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public Alarm withPeriod(Integer period) {
        this.setPeriod(period);
        return this;
    }

    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public Alarm withThreshold(Double threshold) {
        this.setThreshold(threshold);
        return this;
    }

    public void setDatapointsToAlarm(Integer datapointsToAlarm) {
        this.datapointsToAlarm = datapointsToAlarm;
    }

    public Integer getDatapointsToAlarm() {
        return this.datapointsToAlarm;
    }

    public Alarm withDatapointsToAlarm(Integer datapointsToAlarm) {
        this.setDatapointsToAlarm(datapointsToAlarm);
        return this;
    }

    public void setTreatMissingData(String treatMissingData) {
        this.treatMissingData = treatMissingData;
    }

    public String getTreatMissingData() {
        return this.treatMissingData;
    }

    public Alarm withTreatMissingData(String treatMissingData) {
        this.setTreatMissingData(treatMissingData);
        return this;
    }

    public Alarm withTreatMissingData(TreatMissingData treatMissingData) {
        this.treatMissingData = treatMissingData.toString();
        return this;
    }

    public void setStatistic(String statistic) {
        this.statistic = statistic;
    }

    public String getStatistic() {
        return this.statistic;
    }

    public Alarm withStatistic(String statistic) {
        this.setStatistic(statistic);
        return this;
    }

    public Alarm withStatistic(MetricStatistic statistic) {
        this.statistic = statistic.toString();
        return this;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Alarm withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public Alarm withMetricName(MetricName metricName) {
        this.metricName = metricName.toString();
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Alarm withState(String state) {
        this.setState(state);
        return this;
    }

    public Alarm withState(AlarmState state) {
        this.state = state.toString();
        return this;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public Alarm withUnit(String unit) {
        this.setUnit(unit);
        return this;
    }

    public Alarm withUnit(MetricUnit unit) {
        this.unit = unit.toString();
        return this;
    }

    public List<String> getContactProtocols() {
        return this.contactProtocols;
    }

    public void setContactProtocols(Collection<String> contactProtocols) {
        if (contactProtocols == null) {
            this.contactProtocols = null;
            return;
        }
        this.contactProtocols = new ArrayList<String>(contactProtocols);
    }

    public Alarm withContactProtocols(String ... contactProtocols) {
        if (this.contactProtocols == null) {
            this.setContactProtocols(new ArrayList<String>(contactProtocols.length));
        }
        for (String ele : contactProtocols) {
            this.contactProtocols.add(ele);
        }
        return this;
    }

    public Alarm withContactProtocols(Collection<String> contactProtocols) {
        this.setContactProtocols(contactProtocols);
        return this;
    }

    public Alarm withContactProtocols(ContactProtocol ... contactProtocols) {
        ArrayList<String> contactProtocolsCopy = new ArrayList<String>(contactProtocols.length);
        for (ContactProtocol value : contactProtocols) {
            contactProtocolsCopy.add(value.toString());
        }
        if (this.getContactProtocols() == null) {
            this.setContactProtocols(contactProtocolsCopy);
        } else {
            this.getContactProtocols().addAll(contactProtocolsCopy);
        }
        return this;
    }

    public List<String> getNotificationTriggers() {
        return this.notificationTriggers;
    }

    public void setNotificationTriggers(Collection<String> notificationTriggers) {
        if (notificationTriggers == null) {
            this.notificationTriggers = null;
            return;
        }
        this.notificationTriggers = new ArrayList<String>(notificationTriggers);
    }

    public Alarm withNotificationTriggers(String ... notificationTriggers) {
        if (this.notificationTriggers == null) {
            this.setNotificationTriggers(new ArrayList<String>(notificationTriggers.length));
        }
        for (String ele : notificationTriggers) {
            this.notificationTriggers.add(ele);
        }
        return this;
    }

    public Alarm withNotificationTriggers(Collection<String> notificationTriggers) {
        this.setNotificationTriggers(notificationTriggers);
        return this;
    }

    public Alarm withNotificationTriggers(AlarmState ... notificationTriggers) {
        ArrayList<String> notificationTriggersCopy = new ArrayList<String>(notificationTriggers.length);
        for (AlarmState value : notificationTriggers) {
            notificationTriggersCopy.add(value.toString());
        }
        if (this.getNotificationTriggers() == null) {
            this.setNotificationTriggers(notificationTriggersCopy);
        } else {
            this.getNotificationTriggers().addAll(notificationTriggersCopy);
        }
        return this;
    }

    public void setNotificationEnabled(Boolean notificationEnabled) {
        this.notificationEnabled = notificationEnabled;
    }

    public Boolean getNotificationEnabled() {
        return this.notificationEnabled;
    }

    public Alarm withNotificationEnabled(Boolean notificationEnabled) {
        this.setNotificationEnabled(notificationEnabled);
        return this;
    }

    public Boolean isNotificationEnabled() {
        return this.notificationEnabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getSupportCode() != null) {
            sb.append("SupportCode: ").append(this.getSupportCode()).append(",");
        }
        if (this.getMonitoredResourceInfo() != null) {
            sb.append("MonitoredResourceInfo: ").append(this.getMonitoredResourceInfo()).append(",");
        }
        if (this.getComparisonOperator() != null) {
            sb.append("ComparisonOperator: ").append(this.getComparisonOperator()).append(",");
        }
        if (this.getEvaluationPeriods() != null) {
            sb.append("EvaluationPeriods: ").append(this.getEvaluationPeriods()).append(",");
        }
        if (this.getPeriod() != null) {
            sb.append("Period: ").append(this.getPeriod()).append(",");
        }
        if (this.getThreshold() != null) {
            sb.append("Threshold: ").append(this.getThreshold()).append(",");
        }
        if (this.getDatapointsToAlarm() != null) {
            sb.append("DatapointsToAlarm: ").append(this.getDatapointsToAlarm()).append(",");
        }
        if (this.getTreatMissingData() != null) {
            sb.append("TreatMissingData: ").append(this.getTreatMissingData()).append(",");
        }
        if (this.getStatistic() != null) {
            sb.append("Statistic: ").append(this.getStatistic()).append(",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getUnit() != null) {
            sb.append("Unit: ").append(this.getUnit()).append(",");
        }
        if (this.getContactProtocols() != null) {
            sb.append("ContactProtocols: ").append(this.getContactProtocols()).append(",");
        }
        if (this.getNotificationTriggers() != null) {
            sb.append("NotificationTriggers: ").append(this.getNotificationTriggers()).append(",");
        }
        if (this.getNotificationEnabled() != null) {
            sb.append("NotificationEnabled: ").append(this.getNotificationEnabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alarm)) {
            return false;
        }
        Alarm other = (Alarm)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getSupportCode() == null ^ this.getSupportCode() == null) {
            return false;
        }
        if (other.getSupportCode() != null && !other.getSupportCode().equals(this.getSupportCode())) {
            return false;
        }
        if (other.getMonitoredResourceInfo() == null ^ this.getMonitoredResourceInfo() == null) {
            return false;
        }
        if (other.getMonitoredResourceInfo() != null && !other.getMonitoredResourceInfo().equals(this.getMonitoredResourceInfo())) {
            return false;
        }
        if (other.getComparisonOperator() == null ^ this.getComparisonOperator() == null) {
            return false;
        }
        if (other.getComparisonOperator() != null && !other.getComparisonOperator().equals(this.getComparisonOperator())) {
            return false;
        }
        if (other.getEvaluationPeriods() == null ^ this.getEvaluationPeriods() == null) {
            return false;
        }
        if (other.getEvaluationPeriods() != null && !other.getEvaluationPeriods().equals(this.getEvaluationPeriods())) {
            return false;
        }
        if (other.getPeriod() == null ^ this.getPeriod() == null) {
            return false;
        }
        if (other.getPeriod() != null && !other.getPeriod().equals(this.getPeriod())) {
            return false;
        }
        if (other.getThreshold() == null ^ this.getThreshold() == null) {
            return false;
        }
        if (other.getThreshold() != null && !other.getThreshold().equals(this.getThreshold())) {
            return false;
        }
        if (other.getDatapointsToAlarm() == null ^ this.getDatapointsToAlarm() == null) {
            return false;
        }
        if (other.getDatapointsToAlarm() != null && !other.getDatapointsToAlarm().equals(this.getDatapointsToAlarm())) {
            return false;
        }
        if (other.getTreatMissingData() == null ^ this.getTreatMissingData() == null) {
            return false;
        }
        if (other.getTreatMissingData() != null && !other.getTreatMissingData().equals(this.getTreatMissingData())) {
            return false;
        }
        if (other.getStatistic() == null ^ this.getStatistic() == null) {
            return false;
        }
        if (other.getStatistic() != null && !other.getStatistic().equals(this.getStatistic())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getUnit() == null ^ this.getUnit() == null) {
            return false;
        }
        if (other.getUnit() != null && !other.getUnit().equals(this.getUnit())) {
            return false;
        }
        if (other.getContactProtocols() == null ^ this.getContactProtocols() == null) {
            return false;
        }
        if (other.getContactProtocols() != null && !other.getContactProtocols().equals(this.getContactProtocols())) {
            return false;
        }
        if (other.getNotificationTriggers() == null ^ this.getNotificationTriggers() == null) {
            return false;
        }
        if (other.getNotificationTriggers() != null && !other.getNotificationTriggers().equals(this.getNotificationTriggers())) {
            return false;
        }
        if (other.getNotificationEnabled() == null ^ this.getNotificationEnabled() == null) {
            return false;
        }
        return other.getNotificationEnabled() == null || other.getNotificationEnabled().equals(this.getNotificationEnabled());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getSupportCode() == null ? 0 : this.getSupportCode().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoredResourceInfo() == null ? 0 : this.getMonitoredResourceInfo().hashCode());
        hashCode = 31 * hashCode + (this.getComparisonOperator() == null ? 0 : this.getComparisonOperator().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationPeriods() == null ? 0 : this.getEvaluationPeriods().hashCode());
        hashCode = 31 * hashCode + (this.getPeriod() == null ? 0 : this.getPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getThreshold() == null ? 0 : this.getThreshold().hashCode());
        hashCode = 31 * hashCode + (this.getDatapointsToAlarm() == null ? 0 : this.getDatapointsToAlarm().hashCode());
        hashCode = 31 * hashCode + (this.getTreatMissingData() == null ? 0 : this.getTreatMissingData().hashCode());
        hashCode = 31 * hashCode + (this.getStatistic() == null ? 0 : this.getStatistic().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getUnit() == null ? 0 : this.getUnit().hashCode());
        hashCode = 31 * hashCode + (this.getContactProtocols() == null ? 0 : this.getContactProtocols().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationTriggers() == null ? 0 : this.getNotificationTriggers().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationEnabled() == null ? 0 : this.getNotificationEnabled().hashCode());
        return hashCode;
    }

    public Alarm clone() {
        try {
            return (Alarm)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AlarmMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

