/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.licensemanager.model.TokenData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTokensResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<TokenData> tokens;
    private String nextToken;

    public List<TokenData> getTokens() {
        return this.tokens;
    }

    public void setTokens(Collection<TokenData> tokens) {
        if (tokens == null) {
            this.tokens = null;
            return;
        }
        this.tokens = new ArrayList<TokenData>(tokens);
    }

    public ListTokensResult withTokens(TokenData ... tokens) {
        if (this.tokens == null) {
            this.setTokens(new ArrayList<TokenData>(tokens.length));
        }
        for (TokenData ele : tokens) {
            this.tokens.add(ele);
        }
        return this;
    }

    public ListTokensResult withTokens(Collection<TokenData> tokens) {
        this.setTokens(tokens);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTokensResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTokens() != null) {
            sb.append("Tokens: ").append(this.getTokens()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTokensResult)) {
            return false;
        }
        ListTokensResult other = (ListTokensResult)obj;
        if (other.getTokens() == null ^ this.getTokens() == null) {
            return false;
        }
        if (other.getTokens() != null && !other.getTokens().equals(this.getTokens())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTokens() == null ? 0 : this.getTokens().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListTokensResult clone() {
        try {
            return (ListTokensResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

