/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelsv2.model.S3BucketTranscriptSource;

@SdkInternalApi
public class S3BucketTranscriptSourceMarshaller {
    private static final MarshallingInfo<String> S3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3BucketName").build();
    private static final MarshallingInfo<StructuredPojo> PATHFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pathFormat").build();
    private static final MarshallingInfo<String> TRANSCRIPTFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transcriptFormat").build();
    private static final MarshallingInfo<StructuredPojo> TRANSCRIPTFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transcriptFilter").build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsKeyArn").build();
    private static final S3BucketTranscriptSourceMarshaller instance = new S3BucketTranscriptSourceMarshaller();

    public static S3BucketTranscriptSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3BucketTranscriptSource s3BucketTranscriptSource, ProtocolMarshaller protocolMarshaller) {
        if (s3BucketTranscriptSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3BucketTranscriptSource.getS3BucketName(), S3BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3BucketTranscriptSource.getPathFormat(), PATHFORMAT_BINDING);
            protocolMarshaller.marshall((Object)s3BucketTranscriptSource.getTranscriptFormat(), TRANSCRIPTFORMAT_BINDING);
            protocolMarshaller.marshall((Object)s3BucketTranscriptSource.getTranscriptFilter(), TRANSCRIPTFILTER_BINDING);
            protocolMarshaller.marshall((Object)s3BucketTranscriptSource.getKmsKeyArn(), KMSKEYARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

