/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelsv2.model.DialogAction;
import com.amazonaws.services.lexmodelsv2.model.IntentOverride;
import com.amazonaws.services.lexmodelsv2.model.transform.DialogStateMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DialogState
implements Serializable,
Cloneable,
StructuredPojo {
    private DialogAction dialogAction;
    private IntentOverride intent;
    private Map<String, String> sessionAttributes;

    public void setDialogAction(DialogAction dialogAction) {
        this.dialogAction = dialogAction;
    }

    public DialogAction getDialogAction() {
        return this.dialogAction;
    }

    public DialogState withDialogAction(DialogAction dialogAction) {
        this.setDialogAction(dialogAction);
        return this;
    }

    public void setIntent(IntentOverride intent) {
        this.intent = intent;
    }

    public IntentOverride getIntent() {
        return this.intent;
    }

    public DialogState withIntent(IntentOverride intent) {
        this.setIntent(intent);
        return this;
    }

    public Map<String, String> getSessionAttributes() {
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, String> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public DialogState withSessionAttributes(Map<String, String> sessionAttributes) {
        this.setSessionAttributes(sessionAttributes);
        return this;
    }

    public DialogState addSessionAttributesEntry(String key, String value) {
        if (null == this.sessionAttributes) {
            this.sessionAttributes = new HashMap<String, String>();
        }
        if (this.sessionAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.sessionAttributes.put(key, value);
        return this;
    }

    public DialogState clearSessionAttributesEntries() {
        this.sessionAttributes = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDialogAction() != null) {
            sb.append("DialogAction: ").append(this.getDialogAction()).append(",");
        }
        if (this.getIntent() != null) {
            sb.append("Intent: ").append(this.getIntent()).append(",");
        }
        if (this.getSessionAttributes() != null) {
            sb.append("SessionAttributes: ").append(this.getSessionAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DialogState)) {
            return false;
        }
        DialogState other = (DialogState)obj;
        if (other.getDialogAction() == null ^ this.getDialogAction() == null) {
            return false;
        }
        if (other.getDialogAction() != null && !other.getDialogAction().equals(this.getDialogAction())) {
            return false;
        }
        if (other.getIntent() == null ^ this.getIntent() == null) {
            return false;
        }
        if (other.getIntent() != null && !other.getIntent().equals(this.getIntent())) {
            return false;
        }
        if (other.getSessionAttributes() == null ^ this.getSessionAttributes() == null) {
            return false;
        }
        return other.getSessionAttributes() == null || other.getSessionAttributes().equals(this.getSessionAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDialogAction() == null ? 0 : this.getDialogAction().hashCode());
        hashCode = 31 * hashCode + (this.getIntent() == null ? 0 : this.getIntent().hashCode());
        hashCode = 31 * hashCode + (this.getSessionAttributes() == null ? 0 : this.getSessionAttributes().hashCode());
        return hashCode;
    }

    public DialogState clone() {
        try {
            return (DialogState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DialogStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

