/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexruntime.model.DialogActionType;
import com.amazonaws.services.lexruntime.model.FulfillmentState;
import com.amazonaws.services.lexruntime.model.MessageFormatType;
import com.amazonaws.services.lexruntime.model.transform.DialogActionMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DialogAction
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String intentName;
    private Map<String, String> slots;
    private String slotToElicit;
    private String fulfillmentState;
    private String message;
    private String messageFormat;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public DialogAction withType(String type) {
        this.setType(type);
        return this;
    }

    public DialogAction withType(DialogActionType type) {
        this.type = type.toString();
        return this;
    }

    public void setIntentName(String intentName) {
        this.intentName = intentName;
    }

    public String getIntentName() {
        return this.intentName;
    }

    public DialogAction withIntentName(String intentName) {
        this.setIntentName(intentName);
        return this;
    }

    public Map<String, String> getSlots() {
        return this.slots;
    }

    public void setSlots(Map<String, String> slots) {
        this.slots = slots;
    }

    public DialogAction withSlots(Map<String, String> slots) {
        this.setSlots(slots);
        return this;
    }

    public DialogAction addSlotsEntry(String key, String value) {
        if (null == this.slots) {
            this.slots = new HashMap<String, String>();
        }
        if (this.slots.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.slots.put(key, value);
        return this;
    }

    public DialogAction clearSlotsEntries() {
        this.slots = null;
        return this;
    }

    public void setSlotToElicit(String slotToElicit) {
        this.slotToElicit = slotToElicit;
    }

    public String getSlotToElicit() {
        return this.slotToElicit;
    }

    public DialogAction withSlotToElicit(String slotToElicit) {
        this.setSlotToElicit(slotToElicit);
        return this;
    }

    public void setFulfillmentState(String fulfillmentState) {
        this.fulfillmentState = fulfillmentState;
    }

    public String getFulfillmentState() {
        return this.fulfillmentState;
    }

    public DialogAction withFulfillmentState(String fulfillmentState) {
        this.setFulfillmentState(fulfillmentState);
        return this;
    }

    public DialogAction withFulfillmentState(FulfillmentState fulfillmentState) {
        this.fulfillmentState = fulfillmentState.toString();
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public DialogAction withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public void setMessageFormat(String messageFormat) {
        this.messageFormat = messageFormat;
    }

    public String getMessageFormat() {
        return this.messageFormat;
    }

    public DialogAction withMessageFormat(String messageFormat) {
        this.setMessageFormat(messageFormat);
        return this;
    }

    public DialogAction withMessageFormat(MessageFormatType messageFormat) {
        this.messageFormat = messageFormat.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getIntentName() != null) {
            sb.append("IntentName: ").append(this.getIntentName()).append(",");
        }
        if (this.getSlots() != null) {
            sb.append("Slots: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getSlotToElicit() != null) {
            sb.append("SlotToElicit: ").append(this.getSlotToElicit()).append(",");
        }
        if (this.getFulfillmentState() != null) {
            sb.append("FulfillmentState: ").append(this.getFulfillmentState()).append(",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getMessageFormat() != null) {
            sb.append("MessageFormat: ").append(this.getMessageFormat());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DialogAction)) {
            return false;
        }
        DialogAction other = (DialogAction)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getIntentName() == null ^ this.getIntentName() == null) {
            return false;
        }
        if (other.getIntentName() != null && !other.getIntentName().equals(this.getIntentName())) {
            return false;
        }
        if (other.getSlots() == null ^ this.getSlots() == null) {
            return false;
        }
        if (other.getSlots() != null && !other.getSlots().equals(this.getSlots())) {
            return false;
        }
        if (other.getSlotToElicit() == null ^ this.getSlotToElicit() == null) {
            return false;
        }
        if (other.getSlotToElicit() != null && !other.getSlotToElicit().equals(this.getSlotToElicit())) {
            return false;
        }
        if (other.getFulfillmentState() == null ^ this.getFulfillmentState() == null) {
            return false;
        }
        if (other.getFulfillmentState() != null && !other.getFulfillmentState().equals(this.getFulfillmentState())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getMessageFormat() == null ^ this.getMessageFormat() == null) {
            return false;
        }
        return other.getMessageFormat() == null || other.getMessageFormat().equals(this.getMessageFormat());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getIntentName() == null ? 0 : this.getIntentName().hashCode());
        hashCode = 31 * hashCode + (this.getSlots() == null ? 0 : this.getSlots().hashCode());
        hashCode = 31 * hashCode + (this.getSlotToElicit() == null ? 0 : this.getSlotToElicit().hashCode());
        hashCode = 31 * hashCode + (this.getFulfillmentState() == null ? 0 : this.getFulfillmentState().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getMessageFormat() == null ? 0 : this.getMessageFormat().hashCode());
        return hashCode;
    }

    public DialogAction clone() {
        try {
            return (DialogAction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DialogActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

