/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.launchwizard.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.launchwizard.model.WorkloadDataSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListWorkloadsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<WorkloadDataSummary> workloads;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListWorkloadsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<WorkloadDataSummary> getWorkloads() {
        return this.workloads;
    }

    public void setWorkloads(Collection<WorkloadDataSummary> workloads) {
        if (workloads == null) {
            this.workloads = null;
            return;
        }
        this.workloads = new ArrayList<WorkloadDataSummary>(workloads);
    }

    public ListWorkloadsResult withWorkloads(WorkloadDataSummary ... workloads) {
        if (this.workloads == null) {
            this.setWorkloads(new ArrayList<WorkloadDataSummary>(workloads.length));
        }
        for (WorkloadDataSummary ele : workloads) {
            this.workloads.add(ele);
        }
        return this;
    }

    public ListWorkloadsResult withWorkloads(Collection<WorkloadDataSummary> workloads) {
        this.setWorkloads(workloads);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getWorkloads() != null) {
            sb.append("Workloads: ").append(this.getWorkloads());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkloadsResult)) {
            return false;
        }
        ListWorkloadsResult other = (ListWorkloadsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getWorkloads() == null ^ this.getWorkloads() == null) {
            return false;
        }
        return other.getWorkloads() == null || other.getWorkloads().equals(this.getWorkloads());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getWorkloads() == null ? 0 : this.getWorkloads().hashCode());
        return hashCode;
    }

    public ListWorkloadsResult clone() {
        try {
            return (ListWorkloadsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

