/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lakeformation.model.VirtualObject;

@SdkInternalApi
public class VirtualObjectMarshaller {
    private static final MarshallingInfo<String> URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Uri").build();
    private static final MarshallingInfo<String> ETAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ETag").build();
    private static final VirtualObjectMarshaller instance = new VirtualObjectMarshaller();

    public static VirtualObjectMarshaller getInstance() {
        return instance;
    }

    public void marshall(VirtualObject virtualObject, ProtocolMarshaller protocolMarshaller) {
        if (virtualObject == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)virtualObject.getUri(), URI_BINDING);
            protocolMarshaller.marshall((Object)virtualObject.getETag(), ETAG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

