/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.keyspaces;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.keyspaces.AmazonKeyspaces;
import com.amazonaws.services.keyspaces.AmazonKeyspacesClientBuilder;
import com.amazonaws.services.keyspaces.model.AmazonKeyspacesException;
import com.amazonaws.services.keyspaces.model.CreateKeyspaceRequest;
import com.amazonaws.services.keyspaces.model.CreateKeyspaceResult;
import com.amazonaws.services.keyspaces.model.CreateTableRequest;
import com.amazonaws.services.keyspaces.model.CreateTableResult;
import com.amazonaws.services.keyspaces.model.DeleteKeyspaceRequest;
import com.amazonaws.services.keyspaces.model.DeleteKeyspaceResult;
import com.amazonaws.services.keyspaces.model.DeleteTableRequest;
import com.amazonaws.services.keyspaces.model.DeleteTableResult;
import com.amazonaws.services.keyspaces.model.GetKeyspaceRequest;
import com.amazonaws.services.keyspaces.model.GetKeyspaceResult;
import com.amazonaws.services.keyspaces.model.GetTableAutoScalingSettingsRequest;
import com.amazonaws.services.keyspaces.model.GetTableAutoScalingSettingsResult;
import com.amazonaws.services.keyspaces.model.GetTableRequest;
import com.amazonaws.services.keyspaces.model.GetTableResult;
import com.amazonaws.services.keyspaces.model.ListKeyspacesRequest;
import com.amazonaws.services.keyspaces.model.ListKeyspacesResult;
import com.amazonaws.services.keyspaces.model.ListTablesRequest;
import com.amazonaws.services.keyspaces.model.ListTablesResult;
import com.amazonaws.services.keyspaces.model.ListTagsForResourceRequest;
import com.amazonaws.services.keyspaces.model.ListTagsForResourceResult;
import com.amazonaws.services.keyspaces.model.RestoreTableRequest;
import com.amazonaws.services.keyspaces.model.RestoreTableResult;
import com.amazonaws.services.keyspaces.model.TagResourceRequest;
import com.amazonaws.services.keyspaces.model.TagResourceResult;
import com.amazonaws.services.keyspaces.model.UntagResourceRequest;
import com.amazonaws.services.keyspaces.model.UntagResourceResult;
import com.amazonaws.services.keyspaces.model.UpdateTableRequest;
import com.amazonaws.services.keyspaces.model.UpdateTableResult;
import com.amazonaws.services.keyspaces.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.CreateKeyspaceRequestProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.transform.CreateKeyspaceResultJsonUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.CreateTableRequestProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.transform.CreateTableResultJsonUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.DeleteKeyspaceRequestProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.transform.DeleteKeyspaceResultJsonUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.DeleteTableRequestProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.transform.DeleteTableResultJsonUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.GetKeyspaceRequestProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.transform.GetKeyspaceResultJsonUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.GetTableAutoScalingSettingsRequestProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.transform.GetTableAutoScalingSettingsResultJsonUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.GetTableRequestProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.transform.GetTableResultJsonUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.ListKeyspacesRequestProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.transform.ListKeyspacesResultJsonUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.ListTablesRequestProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.transform.ListTablesResultJsonUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.RestoreTableRequestProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.transform.RestoreTableResultJsonUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.UpdateTableRequestProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.transform.UpdateTableResultJsonUnmarshaller;
import com.amazonaws.services.keyspaces.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonKeyspacesClient
extends AmazonWebServiceClient
implements AmazonKeyspaces {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonKeyspaces.class);
    private static final String DEFAULT_SIGNING_NAME = "cassandra";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonKeyspacesException.class));

    public static AmazonKeyspacesClientBuilder builder() {
        return AmazonKeyspacesClientBuilder.standard();
    }

    AmazonKeyspacesClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonKeyspacesClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("cassandra.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/keyspaces/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/keyspaces/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateKeyspaceResult createKeyspace(CreateKeyspaceRequest request) {
        request = (CreateKeyspaceRequest)this.beforeClientExecution(request);
        return this.executeCreateKeyspace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateKeyspaceResult executeCreateKeyspace(CreateKeyspaceRequest createKeyspaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createKeyspaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateKeyspaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateKeyspaceRequestProtocolMarshaller(protocolFactory).marshall((CreateKeyspaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createKeyspaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Keyspaces");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateKeyspace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateKeyspaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateKeyspaceResult createKeyspaceResult = (CreateKeyspaceResult)response.getAwsResponse();
            return createKeyspaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateTableResult createTable(CreateTableRequest request) {
        request = (CreateTableRequest)this.beforeClientExecution(request);
        return this.executeCreateTable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateTableResult executeCreateTable(CreateTableRequest createTableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTableRequestProtocolMarshaller(protocolFactory).marshall((CreateTableRequest)super.beforeMarshalling((AmazonWebServiceRequest)createTableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Keyspaces");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateTable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateTableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateTableResult createTableResult = (CreateTableResult)response.getAwsResponse();
            return createTableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteKeyspaceResult deleteKeyspace(DeleteKeyspaceRequest request) {
        request = (DeleteKeyspaceRequest)this.beforeClientExecution(request);
        return this.executeDeleteKeyspace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteKeyspaceResult executeDeleteKeyspace(DeleteKeyspaceRequest deleteKeyspaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteKeyspaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteKeyspaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteKeyspaceRequestProtocolMarshaller(protocolFactory).marshall((DeleteKeyspaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteKeyspaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Keyspaces");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteKeyspace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteKeyspaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteKeyspaceResult deleteKeyspaceResult = (DeleteKeyspaceResult)response.getAwsResponse();
            return deleteKeyspaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTableResult deleteTable(DeleteTableRequest request) {
        request = (DeleteTableRequest)this.beforeClientExecution(request);
        return this.executeDeleteTable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTableResult executeDeleteTable(DeleteTableRequest deleteTableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTableRequestProtocolMarshaller(protocolFactory).marshall((DeleteTableRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Keyspaces");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteTable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTableResult deleteTableResult = (DeleteTableResult)response.getAwsResponse();
            return deleteTableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetKeyspaceResult getKeyspace(GetKeyspaceRequest request) {
        request = (GetKeyspaceRequest)this.beforeClientExecution(request);
        return this.executeGetKeyspace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetKeyspaceResult executeGetKeyspace(GetKeyspaceRequest getKeyspaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getKeyspaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetKeyspaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetKeyspaceRequestProtocolMarshaller(protocolFactory).marshall((GetKeyspaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)getKeyspaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Keyspaces");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetKeyspace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetKeyspaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetKeyspaceResult getKeyspaceResult = (GetKeyspaceResult)response.getAwsResponse();
            return getKeyspaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTableResult getTable(GetTableRequest request) {
        request = (GetTableRequest)this.beforeClientExecution(request);
        return this.executeGetTable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTableResult executeGetTable(GetTableRequest getTableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTableRequestProtocolMarshaller(protocolFactory).marshall((GetTableRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Keyspaces");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTableResult getTableResult = (GetTableResult)response.getAwsResponse();
            return getTableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTableAutoScalingSettingsResult getTableAutoScalingSettings(GetTableAutoScalingSettingsRequest request) {
        request = (GetTableAutoScalingSettingsRequest)this.beforeClientExecution(request);
        return this.executeGetTableAutoScalingSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTableAutoScalingSettingsResult executeGetTableAutoScalingSettings(GetTableAutoScalingSettingsRequest getTableAutoScalingSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTableAutoScalingSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTableAutoScalingSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTableAutoScalingSettingsRequestProtocolMarshaller(protocolFactory).marshall((GetTableAutoScalingSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTableAutoScalingSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Keyspaces");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTableAutoScalingSettings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTableAutoScalingSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTableAutoScalingSettingsResult getTableAutoScalingSettingsResult = (GetTableAutoScalingSettingsResult)response.getAwsResponse();
            return getTableAutoScalingSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListKeyspacesResult listKeyspaces(ListKeyspacesRequest request) {
        request = (ListKeyspacesRequest)this.beforeClientExecution(request);
        return this.executeListKeyspaces(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListKeyspacesResult executeListKeyspaces(ListKeyspacesRequest listKeyspacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listKeyspacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListKeyspacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListKeyspacesRequestProtocolMarshaller(protocolFactory).marshall((ListKeyspacesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listKeyspacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Keyspaces");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListKeyspaces");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListKeyspacesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListKeyspacesResult listKeyspacesResult = (ListKeyspacesResult)response.getAwsResponse();
            return listKeyspacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTablesResult listTables(ListTablesRequest request) {
        request = (ListTablesRequest)this.beforeClientExecution(request);
        return this.executeListTables(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTablesResult executeListTables(ListTablesRequest listTablesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTablesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTablesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTablesRequestProtocolMarshaller(protocolFactory).marshall((ListTablesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTablesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Keyspaces");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTables");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTablesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTablesResult listTablesResult = (ListTablesResult)response.getAwsResponse();
            return listTablesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Keyspaces");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RestoreTableResult restoreTable(RestoreTableRequest request) {
        request = (RestoreTableRequest)this.beforeClientExecution(request);
        return this.executeRestoreTable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RestoreTableResult executeRestoreTable(RestoreTableRequest restoreTableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(restoreTableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RestoreTableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RestoreTableRequestProtocolMarshaller(protocolFactory).marshall((RestoreTableRequest)super.beforeMarshalling((AmazonWebServiceRequest)restoreTableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Keyspaces");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RestoreTable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RestoreTableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RestoreTableResult restoreTableResult = (RestoreTableResult)response.getAwsResponse();
            return restoreTableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Keyspaces");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Keyspaces");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateTableResult updateTable(UpdateTableRequest request) {
        request = (UpdateTableRequest)this.beforeClientExecution(request);
        return this.executeUpdateTable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateTableResult executeUpdateTable(UpdateTableRequest updateTableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateTableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateTableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateTableRequestProtocolMarshaller(protocolFactory).marshall((UpdateTableRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateTableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Keyspaces");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateTable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateTableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateTableResult updateTableResult = (UpdateTableResult)response.getAwsResponse();
            return updateTableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

