/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kendra.model.ContentSourceConfiguration;
import java.util.List;

@SdkInternalApi
public class ContentSourceConfigurationMarshaller {
    private static final MarshallingInfo<List> DATASOURCEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSourceIds").build();
    private static final MarshallingInfo<List> FAQIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FaqIds").build();
    private static final MarshallingInfo<Boolean> DIRECTPUTCONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DirectPutContent").build();
    private static final ContentSourceConfigurationMarshaller instance = new ContentSourceConfigurationMarshaller();

    public static ContentSourceConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ContentSourceConfiguration contentSourceConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (contentSourceConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(contentSourceConfiguration.getDataSourceIds(), DATASOURCEIDS_BINDING);
            protocolMarshaller.marshall(contentSourceConfiguration.getFaqIds(), FAQIDS_BINDING);
            protocolMarshaller.marshall((Object)contentSourceConfiguration.getDirectPutContent(), DIRECTPUTCONTENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

