/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DocumentAttribute;
import com.amazonaws.services.kendra.model.transform.DocumentInfoMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DocumentInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private String documentId;
    private List<DocumentAttribute> attributes;

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public DocumentInfo withDocumentId(String documentId) {
        this.setDocumentId(documentId);
        return this;
    }

    public List<DocumentAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<DocumentAttribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<DocumentAttribute>(attributes);
    }

    public DocumentInfo withAttributes(DocumentAttribute ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<DocumentAttribute>(attributes.length));
        }
        for (DocumentAttribute ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public DocumentInfo withAttributes(Collection<DocumentAttribute> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentId() != null) {
            sb.append("DocumentId: ").append(this.getDocumentId()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentInfo)) {
            return false;
        }
        DocumentInfo other = (DocumentInfo)obj;
        if (other.getDocumentId() == null ^ this.getDocumentId() == null) {
            return false;
        }
        if (other.getDocumentId() != null && !other.getDocumentId().equals(this.getDocumentId())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || other.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentId() == null ? 0 : this.getDocumentId().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        return hashCode;
    }

    public DocumentInfo clone() {
        try {
            return (DocumentInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

