/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration;
import com.amazonaws.services.kendra.model.SalesforceKnowledgeArticleState;
import com.amazonaws.services.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration;
import com.amazonaws.services.kendra.model.transform.SalesforceKnowledgeArticleConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SalesforceKnowledgeArticleConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> includedStates;
    private SalesforceStandardKnowledgeArticleTypeConfiguration standardKnowledgeArticleTypeConfiguration;
    private List<SalesforceCustomKnowledgeArticleTypeConfiguration> customKnowledgeArticleTypeConfigurations;

    public List<String> getIncludedStates() {
        return this.includedStates;
    }

    public void setIncludedStates(Collection<String> includedStates) {
        if (includedStates == null) {
            this.includedStates = null;
            return;
        }
        this.includedStates = new ArrayList<String>(includedStates);
    }

    public SalesforceKnowledgeArticleConfiguration withIncludedStates(String ... includedStates) {
        if (this.includedStates == null) {
            this.setIncludedStates(new ArrayList<String>(includedStates.length));
        }
        for (String ele : includedStates) {
            this.includedStates.add(ele);
        }
        return this;
    }

    public SalesforceKnowledgeArticleConfiguration withIncludedStates(Collection<String> includedStates) {
        this.setIncludedStates(includedStates);
        return this;
    }

    public SalesforceKnowledgeArticleConfiguration withIncludedStates(SalesforceKnowledgeArticleState ... includedStates) {
        ArrayList<String> includedStatesCopy = new ArrayList<String>(includedStates.length);
        for (SalesforceKnowledgeArticleState value : includedStates) {
            includedStatesCopy.add(value.toString());
        }
        if (this.getIncludedStates() == null) {
            this.setIncludedStates(includedStatesCopy);
        } else {
            this.getIncludedStates().addAll(includedStatesCopy);
        }
        return this;
    }

    public void setStandardKnowledgeArticleTypeConfiguration(SalesforceStandardKnowledgeArticleTypeConfiguration standardKnowledgeArticleTypeConfiguration) {
        this.standardKnowledgeArticleTypeConfiguration = standardKnowledgeArticleTypeConfiguration;
    }

    public SalesforceStandardKnowledgeArticleTypeConfiguration getStandardKnowledgeArticleTypeConfiguration() {
        return this.standardKnowledgeArticleTypeConfiguration;
    }

    public SalesforceKnowledgeArticleConfiguration withStandardKnowledgeArticleTypeConfiguration(SalesforceStandardKnowledgeArticleTypeConfiguration standardKnowledgeArticleTypeConfiguration) {
        this.setStandardKnowledgeArticleTypeConfiguration(standardKnowledgeArticleTypeConfiguration);
        return this;
    }

    public List<SalesforceCustomKnowledgeArticleTypeConfiguration> getCustomKnowledgeArticleTypeConfigurations() {
        return this.customKnowledgeArticleTypeConfigurations;
    }

    public void setCustomKnowledgeArticleTypeConfigurations(Collection<SalesforceCustomKnowledgeArticleTypeConfiguration> customKnowledgeArticleTypeConfigurations) {
        if (customKnowledgeArticleTypeConfigurations == null) {
            this.customKnowledgeArticleTypeConfigurations = null;
            return;
        }
        this.customKnowledgeArticleTypeConfigurations = new ArrayList<SalesforceCustomKnowledgeArticleTypeConfiguration>(customKnowledgeArticleTypeConfigurations);
    }

    public SalesforceKnowledgeArticleConfiguration withCustomKnowledgeArticleTypeConfigurations(SalesforceCustomKnowledgeArticleTypeConfiguration ... customKnowledgeArticleTypeConfigurations) {
        if (this.customKnowledgeArticleTypeConfigurations == null) {
            this.setCustomKnowledgeArticleTypeConfigurations(new ArrayList<SalesforceCustomKnowledgeArticleTypeConfiguration>(customKnowledgeArticleTypeConfigurations.length));
        }
        for (SalesforceCustomKnowledgeArticleTypeConfiguration ele : customKnowledgeArticleTypeConfigurations) {
            this.customKnowledgeArticleTypeConfigurations.add(ele);
        }
        return this;
    }

    public SalesforceKnowledgeArticleConfiguration withCustomKnowledgeArticleTypeConfigurations(Collection<SalesforceCustomKnowledgeArticleTypeConfiguration> customKnowledgeArticleTypeConfigurations) {
        this.setCustomKnowledgeArticleTypeConfigurations(customKnowledgeArticleTypeConfigurations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIncludedStates() != null) {
            sb.append("IncludedStates: ").append(this.getIncludedStates()).append(",");
        }
        if (this.getStandardKnowledgeArticleTypeConfiguration() != null) {
            sb.append("StandardKnowledgeArticleTypeConfiguration: ").append(this.getStandardKnowledgeArticleTypeConfiguration()).append(",");
        }
        if (this.getCustomKnowledgeArticleTypeConfigurations() != null) {
            sb.append("CustomKnowledgeArticleTypeConfigurations: ").append(this.getCustomKnowledgeArticleTypeConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceKnowledgeArticleConfiguration)) {
            return false;
        }
        SalesforceKnowledgeArticleConfiguration other = (SalesforceKnowledgeArticleConfiguration)obj;
        if (other.getIncludedStates() == null ^ this.getIncludedStates() == null) {
            return false;
        }
        if (other.getIncludedStates() != null && !other.getIncludedStates().equals(this.getIncludedStates())) {
            return false;
        }
        if (other.getStandardKnowledgeArticleTypeConfiguration() == null ^ this.getStandardKnowledgeArticleTypeConfiguration() == null) {
            return false;
        }
        if (other.getStandardKnowledgeArticleTypeConfiguration() != null && !other.getStandardKnowledgeArticleTypeConfiguration().equals(this.getStandardKnowledgeArticleTypeConfiguration())) {
            return false;
        }
        if (other.getCustomKnowledgeArticleTypeConfigurations() == null ^ this.getCustomKnowledgeArticleTypeConfigurations() == null) {
            return false;
        }
        return other.getCustomKnowledgeArticleTypeConfigurations() == null || other.getCustomKnowledgeArticleTypeConfigurations().equals(this.getCustomKnowledgeArticleTypeConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIncludedStates() == null ? 0 : this.getIncludedStates().hashCode());
        hashCode = 31 * hashCode + (this.getStandardKnowledgeArticleTypeConfiguration() == null ? 0 : this.getStandardKnowledgeArticleTypeConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getCustomKnowledgeArticleTypeConfigurations() == null ? 0 : this.getCustomKnowledgeArticleTypeConfigurations().hashCode());
        return hashCode;
    }

    public SalesforceKnowledgeArticleConfiguration clone() {
        try {
            return (SalesforceKnowledgeArticleConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SalesforceKnowledgeArticleConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

