/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DataSourceToIndexFieldMapping;
import com.amazonaws.services.kendra.model.DataSourceVpcConfiguration;
import com.amazonaws.services.kendra.model.transform.QuipConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QuipConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String domain;
    private String secretArn;
    private Boolean crawlFileComments;
    private Boolean crawlChatRooms;
    private Boolean crawlAttachments;
    private List<String> folderIds;
    private List<DataSourceToIndexFieldMapping> threadFieldMappings;
    private List<DataSourceToIndexFieldMapping> messageFieldMappings;
    private List<DataSourceToIndexFieldMapping> attachmentFieldMappings;
    private List<String> inclusionPatterns;
    private List<String> exclusionPatterns;
    private DataSourceVpcConfiguration vpcConfiguration;

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public QuipConfiguration withDomain(String domain) {
        this.setDomain(domain);
        return this;
    }

    public void setSecretArn(String secretArn) {
        this.secretArn = secretArn;
    }

    public String getSecretArn() {
        return this.secretArn;
    }

    public QuipConfiguration withSecretArn(String secretArn) {
        this.setSecretArn(secretArn);
        return this;
    }

    public void setCrawlFileComments(Boolean crawlFileComments) {
        this.crawlFileComments = crawlFileComments;
    }

    public Boolean getCrawlFileComments() {
        return this.crawlFileComments;
    }

    public QuipConfiguration withCrawlFileComments(Boolean crawlFileComments) {
        this.setCrawlFileComments(crawlFileComments);
        return this;
    }

    public Boolean isCrawlFileComments() {
        return this.crawlFileComments;
    }

    public void setCrawlChatRooms(Boolean crawlChatRooms) {
        this.crawlChatRooms = crawlChatRooms;
    }

    public Boolean getCrawlChatRooms() {
        return this.crawlChatRooms;
    }

    public QuipConfiguration withCrawlChatRooms(Boolean crawlChatRooms) {
        this.setCrawlChatRooms(crawlChatRooms);
        return this;
    }

    public Boolean isCrawlChatRooms() {
        return this.crawlChatRooms;
    }

    public void setCrawlAttachments(Boolean crawlAttachments) {
        this.crawlAttachments = crawlAttachments;
    }

    public Boolean getCrawlAttachments() {
        return this.crawlAttachments;
    }

    public QuipConfiguration withCrawlAttachments(Boolean crawlAttachments) {
        this.setCrawlAttachments(crawlAttachments);
        return this;
    }

    public Boolean isCrawlAttachments() {
        return this.crawlAttachments;
    }

    public List<String> getFolderIds() {
        return this.folderIds;
    }

    public void setFolderIds(Collection<String> folderIds) {
        if (folderIds == null) {
            this.folderIds = null;
            return;
        }
        this.folderIds = new ArrayList<String>(folderIds);
    }

    public QuipConfiguration withFolderIds(String ... folderIds) {
        if (this.folderIds == null) {
            this.setFolderIds(new ArrayList<String>(folderIds.length));
        }
        for (String ele : folderIds) {
            this.folderIds.add(ele);
        }
        return this;
    }

    public QuipConfiguration withFolderIds(Collection<String> folderIds) {
        this.setFolderIds(folderIds);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getThreadFieldMappings() {
        return this.threadFieldMappings;
    }

    public void setThreadFieldMappings(Collection<DataSourceToIndexFieldMapping> threadFieldMappings) {
        if (threadFieldMappings == null) {
            this.threadFieldMappings = null;
            return;
        }
        this.threadFieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(threadFieldMappings);
    }

    public QuipConfiguration withThreadFieldMappings(DataSourceToIndexFieldMapping ... threadFieldMappings) {
        if (this.threadFieldMappings == null) {
            this.setThreadFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(threadFieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : threadFieldMappings) {
            this.threadFieldMappings.add(ele);
        }
        return this;
    }

    public QuipConfiguration withThreadFieldMappings(Collection<DataSourceToIndexFieldMapping> threadFieldMappings) {
        this.setThreadFieldMappings(threadFieldMappings);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getMessageFieldMappings() {
        return this.messageFieldMappings;
    }

    public void setMessageFieldMappings(Collection<DataSourceToIndexFieldMapping> messageFieldMappings) {
        if (messageFieldMappings == null) {
            this.messageFieldMappings = null;
            return;
        }
        this.messageFieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(messageFieldMappings);
    }

    public QuipConfiguration withMessageFieldMappings(DataSourceToIndexFieldMapping ... messageFieldMappings) {
        if (this.messageFieldMappings == null) {
            this.setMessageFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(messageFieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : messageFieldMappings) {
            this.messageFieldMappings.add(ele);
        }
        return this;
    }

    public QuipConfiguration withMessageFieldMappings(Collection<DataSourceToIndexFieldMapping> messageFieldMappings) {
        this.setMessageFieldMappings(messageFieldMappings);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getAttachmentFieldMappings() {
        return this.attachmentFieldMappings;
    }

    public void setAttachmentFieldMappings(Collection<DataSourceToIndexFieldMapping> attachmentFieldMappings) {
        if (attachmentFieldMappings == null) {
            this.attachmentFieldMappings = null;
            return;
        }
        this.attachmentFieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(attachmentFieldMappings);
    }

    public QuipConfiguration withAttachmentFieldMappings(DataSourceToIndexFieldMapping ... attachmentFieldMappings) {
        if (this.attachmentFieldMappings == null) {
            this.setAttachmentFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(attachmentFieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : attachmentFieldMappings) {
            this.attachmentFieldMappings.add(ele);
        }
        return this;
    }

    public QuipConfiguration withAttachmentFieldMappings(Collection<DataSourceToIndexFieldMapping> attachmentFieldMappings) {
        this.setAttachmentFieldMappings(attachmentFieldMappings);
        return this;
    }

    public List<String> getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public void setInclusionPatterns(Collection<String> inclusionPatterns) {
        if (inclusionPatterns == null) {
            this.inclusionPatterns = null;
            return;
        }
        this.inclusionPatterns = new ArrayList<String>(inclusionPatterns);
    }

    public QuipConfiguration withInclusionPatterns(String ... inclusionPatterns) {
        if (this.inclusionPatterns == null) {
            this.setInclusionPatterns(new ArrayList<String>(inclusionPatterns.length));
        }
        for (String ele : inclusionPatterns) {
            this.inclusionPatterns.add(ele);
        }
        return this;
    }

    public QuipConfiguration withInclusionPatterns(Collection<String> inclusionPatterns) {
        this.setInclusionPatterns(inclusionPatterns);
        return this;
    }

    public List<String> getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public void setExclusionPatterns(Collection<String> exclusionPatterns) {
        if (exclusionPatterns == null) {
            this.exclusionPatterns = null;
            return;
        }
        this.exclusionPatterns = new ArrayList<String>(exclusionPatterns);
    }

    public QuipConfiguration withExclusionPatterns(String ... exclusionPatterns) {
        if (this.exclusionPatterns == null) {
            this.setExclusionPatterns(new ArrayList<String>(exclusionPatterns.length));
        }
        for (String ele : exclusionPatterns) {
            this.exclusionPatterns.add(ele);
        }
        return this;
    }

    public QuipConfiguration withExclusionPatterns(Collection<String> exclusionPatterns) {
        this.setExclusionPatterns(exclusionPatterns);
        return this;
    }

    public void setVpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
        this.vpcConfiguration = vpcConfiguration;
    }

    public DataSourceVpcConfiguration getVpcConfiguration() {
        return this.vpcConfiguration;
    }

    public QuipConfiguration withVpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
        this.setVpcConfiguration(vpcConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomain() != null) {
            sb.append("Domain: ").append(this.getDomain()).append(",");
        }
        if (this.getSecretArn() != null) {
            sb.append("SecretArn: ").append(this.getSecretArn()).append(",");
        }
        if (this.getCrawlFileComments() != null) {
            sb.append("CrawlFileComments: ").append(this.getCrawlFileComments()).append(",");
        }
        if (this.getCrawlChatRooms() != null) {
            sb.append("CrawlChatRooms: ").append(this.getCrawlChatRooms()).append(",");
        }
        if (this.getCrawlAttachments() != null) {
            sb.append("CrawlAttachments: ").append(this.getCrawlAttachments()).append(",");
        }
        if (this.getFolderIds() != null) {
            sb.append("FolderIds: ").append(this.getFolderIds()).append(",");
        }
        if (this.getThreadFieldMappings() != null) {
            sb.append("ThreadFieldMappings: ").append(this.getThreadFieldMappings()).append(",");
        }
        if (this.getMessageFieldMappings() != null) {
            sb.append("MessageFieldMappings: ").append(this.getMessageFieldMappings()).append(",");
        }
        if (this.getAttachmentFieldMappings() != null) {
            sb.append("AttachmentFieldMappings: ").append(this.getAttachmentFieldMappings()).append(",");
        }
        if (this.getInclusionPatterns() != null) {
            sb.append("InclusionPatterns: ").append(this.getInclusionPatterns()).append(",");
        }
        if (this.getExclusionPatterns() != null) {
            sb.append("ExclusionPatterns: ").append(this.getExclusionPatterns()).append(",");
        }
        if (this.getVpcConfiguration() != null) {
            sb.append("VpcConfiguration: ").append(this.getVpcConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuipConfiguration)) {
            return false;
        }
        QuipConfiguration other = (QuipConfiguration)obj;
        if (other.getDomain() == null ^ this.getDomain() == null) {
            return false;
        }
        if (other.getDomain() != null && !other.getDomain().equals(this.getDomain())) {
            return false;
        }
        if (other.getSecretArn() == null ^ this.getSecretArn() == null) {
            return false;
        }
        if (other.getSecretArn() != null && !other.getSecretArn().equals(this.getSecretArn())) {
            return false;
        }
        if (other.getCrawlFileComments() == null ^ this.getCrawlFileComments() == null) {
            return false;
        }
        if (other.getCrawlFileComments() != null && !other.getCrawlFileComments().equals(this.getCrawlFileComments())) {
            return false;
        }
        if (other.getCrawlChatRooms() == null ^ this.getCrawlChatRooms() == null) {
            return false;
        }
        if (other.getCrawlChatRooms() != null && !other.getCrawlChatRooms().equals(this.getCrawlChatRooms())) {
            return false;
        }
        if (other.getCrawlAttachments() == null ^ this.getCrawlAttachments() == null) {
            return false;
        }
        if (other.getCrawlAttachments() != null && !other.getCrawlAttachments().equals(this.getCrawlAttachments())) {
            return false;
        }
        if (other.getFolderIds() == null ^ this.getFolderIds() == null) {
            return false;
        }
        if (other.getFolderIds() != null && !other.getFolderIds().equals(this.getFolderIds())) {
            return false;
        }
        if (other.getThreadFieldMappings() == null ^ this.getThreadFieldMappings() == null) {
            return false;
        }
        if (other.getThreadFieldMappings() != null && !other.getThreadFieldMappings().equals(this.getThreadFieldMappings())) {
            return false;
        }
        if (other.getMessageFieldMappings() == null ^ this.getMessageFieldMappings() == null) {
            return false;
        }
        if (other.getMessageFieldMappings() != null && !other.getMessageFieldMappings().equals(this.getMessageFieldMappings())) {
            return false;
        }
        if (other.getAttachmentFieldMappings() == null ^ this.getAttachmentFieldMappings() == null) {
            return false;
        }
        if (other.getAttachmentFieldMappings() != null && !other.getAttachmentFieldMappings().equals(this.getAttachmentFieldMappings())) {
            return false;
        }
        if (other.getInclusionPatterns() == null ^ this.getInclusionPatterns() == null) {
            return false;
        }
        if (other.getInclusionPatterns() != null && !other.getInclusionPatterns().equals(this.getInclusionPatterns())) {
            return false;
        }
        if (other.getExclusionPatterns() == null ^ this.getExclusionPatterns() == null) {
            return false;
        }
        if (other.getExclusionPatterns() != null && !other.getExclusionPatterns().equals(this.getExclusionPatterns())) {
            return false;
        }
        if (other.getVpcConfiguration() == null ^ this.getVpcConfiguration() == null) {
            return false;
        }
        return other.getVpcConfiguration() == null || other.getVpcConfiguration().equals(this.getVpcConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomain() == null ? 0 : this.getDomain().hashCode());
        hashCode = 31 * hashCode + (this.getSecretArn() == null ? 0 : this.getSecretArn().hashCode());
        hashCode = 31 * hashCode + (this.getCrawlFileComments() == null ? 0 : this.getCrawlFileComments().hashCode());
        hashCode = 31 * hashCode + (this.getCrawlChatRooms() == null ? 0 : this.getCrawlChatRooms().hashCode());
        hashCode = 31 * hashCode + (this.getCrawlAttachments() == null ? 0 : this.getCrawlAttachments().hashCode());
        hashCode = 31 * hashCode + (this.getFolderIds() == null ? 0 : this.getFolderIds().hashCode());
        hashCode = 31 * hashCode + (this.getThreadFieldMappings() == null ? 0 : this.getThreadFieldMappings().hashCode());
        hashCode = 31 * hashCode + (this.getMessageFieldMappings() == null ? 0 : this.getMessageFieldMappings().hashCode());
        hashCode = 31 * hashCode + (this.getAttachmentFieldMappings() == null ? 0 : this.getAttachmentFieldMappings().hashCode());
        hashCode = 31 * hashCode + (this.getInclusionPatterns() == null ? 0 : this.getInclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getExclusionPatterns() == null ? 0 : this.getExclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfiguration() == null ? 0 : this.getVpcConfiguration().hashCode());
        return hashCode;
    }

    public QuipConfiguration clone() {
        try {
            return (QuipConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QuipConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

