/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateConfigurationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String description;
    private List<String> kafkaVersions;
    private String name;
    private ByteBuffer serverProperties;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateConfigurationRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getKafkaVersions() {
        return this.kafkaVersions;
    }

    public void setKafkaVersions(Collection<String> kafkaVersions) {
        if (kafkaVersions == null) {
            this.kafkaVersions = null;
            return;
        }
        this.kafkaVersions = new ArrayList<String>(kafkaVersions);
    }

    public CreateConfigurationRequest withKafkaVersions(String ... kafkaVersions) {
        if (this.kafkaVersions == null) {
            this.setKafkaVersions(new ArrayList<String>(kafkaVersions.length));
        }
        for (String ele : kafkaVersions) {
            this.kafkaVersions.add(ele);
        }
        return this;
    }

    public CreateConfigurationRequest withKafkaVersions(Collection<String> kafkaVersions) {
        this.setKafkaVersions(kafkaVersions);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateConfigurationRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setServerProperties(ByteBuffer serverProperties) {
        this.serverProperties = serverProperties;
    }

    public ByteBuffer getServerProperties() {
        return this.serverProperties;
    }

    public CreateConfigurationRequest withServerProperties(ByteBuffer serverProperties) {
        this.setServerProperties(serverProperties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getKafkaVersions() != null) {
            sb.append("KafkaVersions: ").append(this.getKafkaVersions()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getServerProperties() != null) {
            sb.append("ServerProperties: ").append(this.getServerProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationRequest)) {
            return false;
        }
        CreateConfigurationRequest other = (CreateConfigurationRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getKafkaVersions() == null ^ this.getKafkaVersions() == null) {
            return false;
        }
        if (other.getKafkaVersions() != null && !other.getKafkaVersions().equals(this.getKafkaVersions())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getServerProperties() == null ^ this.getServerProperties() == null) {
            return false;
        }
        return other.getServerProperties() == null || other.getServerProperties().equals(this.getServerProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getKafkaVersions() == null ? 0 : this.getKafkaVersions().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getServerProperties() == null ? 0 : this.getServerProperties().hashCode());
        return hashCode;
    }

    public CreateConfigurationRequest clone() {
        return (CreateConfigurationRequest)super.clone();
    }
}

