/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.ivs.model.StreamSessionSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListStreamSessionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<StreamSessionSummary> streamSessions;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListStreamSessionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<StreamSessionSummary> getStreamSessions() {
        return this.streamSessions;
    }

    public void setStreamSessions(Collection<StreamSessionSummary> streamSessions) {
        if (streamSessions == null) {
            this.streamSessions = null;
            return;
        }
        this.streamSessions = new ArrayList<StreamSessionSummary>(streamSessions);
    }

    public ListStreamSessionsResult withStreamSessions(StreamSessionSummary ... streamSessions) {
        if (this.streamSessions == null) {
            this.setStreamSessions(new ArrayList<StreamSessionSummary>(streamSessions.length));
        }
        for (StreamSessionSummary ele : streamSessions) {
            this.streamSessions.add(ele);
        }
        return this;
    }

    public ListStreamSessionsResult withStreamSessions(Collection<StreamSessionSummary> streamSessions) {
        this.setStreamSessions(streamSessions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getStreamSessions() != null) {
            sb.append("StreamSessions: ").append(this.getStreamSessions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamSessionsResult)) {
            return false;
        }
        ListStreamSessionsResult other = (ListStreamSessionsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getStreamSessions() == null ^ this.getStreamSessions() == null) {
            return false;
        }
        return other.getStreamSessions() == null || other.getStreamSessions().equals(this.getStreamSessions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getStreamSessions() == null ? 0 : this.getStreamSessions().hashCode());
        return hashCode;
    }

    public ListStreamSessionsResult clone() {
        try {
            return (ListStreamSessionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

